/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.maintenance;

import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.status.server.WrapperStatusServerResponse;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Path;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.maintenance.listener.MaintenancePacketListener;
import net.flectone.pulse.module.command.maintenance.listener.MaintenancePulseListener;
import net.flectone.pulse.module.command.maintenance.model.MaintenanceMetadata;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.IconUtil;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class MaintenanceModule
extends AbstractModuleCommand<Localization.Command.Maintenance> {
    private final Command.Maintenance command;
    private final Permission.Command.Maintenance permission;
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;
    private final ListenerRegistry listenerRegistry;
    private final Path iconPath;
    private final PlatformServerAdapter platformServerAdapter;
    private final MessagePipeline messagePipeline;
    private final IconUtil iconUtil;
    private String icon;

    @Inject
    public MaintenanceModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker, ListenerRegistry listenerRegistry, @Named(value="projectPath") Path projectPath, PlatformServerAdapter platformServerAdapter, MessagePipeline messagePipeline, IconUtil iconUtil) {
        super(module -> module.getCommand().getMaintenance(), Command::getMaintenance, MessageType.COMMAND_MAINTENANCE);
        this.command = fileResolver.getCommand().getMaintenance();
        this.permission = fileResolver.getPermission().getCommand().getMaintenance();
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
        this.listenerRegistry = listenerRegistry;
        this.iconPath = projectPath.resolve("images");
        this.platformServerAdapter = platformServerAdapter;
        this.messagePipeline = messagePipeline;
        this.iconUtil = iconUtil;
    }

    @Override
    public void onEnable() {
        if (this.isModuleDisabledFor(FPlayer.UNKNOWN)) {
            return;
        }
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        this.registerPermission(this.permission.getJoin());
        this.listenerRegistry.register(MaintenancePacketListener.class);
        this.listenerRegistry.register(MaintenancePulseListener.class);
        File file = new File(this.iconPath.toString() + File.separator + "maintenance.png");
        if (!file.exists()) {
            this.platformServerAdapter.saveResource("images" + File.separator + "maintenance.png");
        }
        this.icon = this.iconUtil.convertIcon(file);
        if (this.command.isTurnedOn()) {
            this.kickOnlinePlayers(FPlayer.UNKNOWN);
        }
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()));
        this.addPredicate(this::checkCooldown);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        boolean turned = !this.command.isTurnedOn();
        this.command.setTurnedOn(turned);
        this.fileResolver.save();
        this.sendMessage(((MaintenanceMetadata.MaintenanceMetadataBuilder)((MaintenanceMetadata.MaintenanceMetadataBuilder)((EventMetadata.EventMetadataBuilder)((MaintenanceMetadata.MaintenanceMetadataBuilder)((MaintenanceMetadata.MaintenanceMetadataBuilder)MaintenanceMetadata.builder().sender(fPlayer)).format(maintenance -> turned ? maintenance.getFormatTrue() : maintenance.getFormatFalse())).turned(turned)).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
        if (turned) {
            this.kickOnlinePlayers(fPlayer);
        }
    }

    public void sendStatus(User user) {
        if (!this.isEnable()) {
            return;
        }
        if (!this.command.isTurnedOn()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(user.getAddress().getAddress());
        this.fPlayerService.loadColors(fPlayer);
        JsonObject responseJson = new JsonObject();
        Localization.Command.Maintenance localizationMaintenance = (Localization.Command.Maintenance)this.resolveLocalization(fPlayer);
        responseJson.add("version", this.getVersionJson(localizationMaintenance.getServerVersion()));
        responseJson.add("players", this.getPlayersJson());
        responseJson.add("description", this.messagePipeline.builder(fPlayer, localizationMaintenance.getServerDescription()).jsonSerializerBuild());
        responseJson.addProperty("favicon", "data:image/png;base64," + (this.icon == null ? "" : this.icon));
        responseJson.addProperty("enforcesSecureChat", Boolean.valueOf(false));
        WrapperStatusServerResponse wrapperStatusServerResponse = new WrapperStatusServerResponse(responseJson);
        user.sendPacket((PacketWrapper)wrapperStatusServerResponse);
    }

    public boolean isAllowed(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return true;
        }
        if (!this.command.isTurnedOn()) {
            return true;
        }
        return this.permissionChecker.check((FEntity)fPlayer, this.permission.getJoin());
    }

    private JsonElement getVersionJson(String message) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", message);
        jsonObject.addProperty("protocol", (Number)-1);
        return jsonObject;
    }

    private JsonElement getPlayersJson() {
        JsonObject playersJson = new JsonObject();
        playersJson.addProperty("max", (Number)-1);
        playersJson.addProperty("online", (Number)-1);
        playersJson.add("sample", (JsonElement)new JsonArray());
        return playersJson;
    }

    private void kickOnlinePlayers(FPlayer fSender) {
        this.fPlayerService.getOnlineFPlayers().stream().filter(filter -> !this.permissionChecker.check((FEntity)filter, this.permission.getJoin())).forEach(fReceiver -> {
            Component component = this.messagePipeline.builder(fSender, (FPlayer)fReceiver, ((Localization.Command.Maintenance)this.resolveLocalization((FEntity)fReceiver)).getKick()).build();
            this.fPlayerService.kick((FPlayer)fReceiver, component);
        });
    }
}

