/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.maintenance.listener;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.command.maintenance.MaintenanceModule;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class MaintenancePacketListener
implements PacketListener {
    private final Command.Maintenance command;
    private final MaintenanceModule maintenanceModule;

    @Inject
    public MaintenancePacketListener(FileResolver fileResolver, MaintenanceModule maintenanceModule) {
        this.command = fileResolver.getCommand().getMaintenance();
        this.maintenanceModule = maintenanceModule;
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() == PacketType.Status.Client.REQUEST) {
            if (!this.command.isTurnedOn()) {
                return;
            }
            event.setCancelled(true);
            this.maintenanceModule.sendStatus(event.getUser());
        }
    }
}

