/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ping;

import java.util.Optional;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class PingModule
extends AbstractModuleCommand<Localization.Command.Ping> {
    private final Command.Ping command;
    private final Permission.Command.Ping permission;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final IntegrationModule integrationModule;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Inject
    public PingModule(FileResolver fileResolver, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, IntegrationModule integrationModule, PlatformPlayerAdapter platformPlayerAdapter) {
        super(localization -> localization.getCommand().getPing(), Command::getPing, MessageType.COMMAND_PING);
        this.command = fileResolver.getCommand().getPing();
        this.permission = fileResolver.getPermission().getCommand().getPing();
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.integrationModule = integrationModule;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission.getName()).optional(promptPlayer, this.commandParserProvider.platformPlayerParser()));
        this.addPredicate(this::checkCooldown);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        FPlayer fTarget;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String promptPlayer = this.getPrompt(0);
        Optional optionalTarget = commandContext.optional(promptPlayer);
        FPlayer fPlayer2 = fTarget = optionalTarget.isPresent() ? this.fPlayerService.getFPlayer((String)optionalTarget.get()) : fPlayer;
        if (!this.platformPlayerAdapter.isOnline(fTarget) || !this.integrationModule.canSeeVanished(fTarget, fPlayer) && !fPlayer.equals(fTarget)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ping::getNullPlayer)).build());
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fTarget)).filterPlayer(fPlayer)).format(Localization.Command.Ping::getFormat)).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
    }
}

