/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.reply;

import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.tell.TellModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class ReplyModule
extends AbstractModuleCommand<Localization.Command.Reply> {
    private final Command.Reply command;
    private final Permission.Command.Reply permission;
    private final TellModule tellModule;
    private final CommandParserProvider commandParserProvider;

    @Inject
    public ReplyModule(FileResolver fileResolver, TellModule tellModule, CommandParserProvider commandParserProvider) {
        super(localization -> localization.getCommand().getReply(), Command::getReply, fPlayer -> fPlayer.isSetting(FPlayer.Setting.REPLY), MessageType.COMMAND_REPLY);
        this.command = fileResolver.getCommand().getReply();
        this.permission = fileResolver.getPermission().getCommand().getReply();
        this.tellModule = tellModule;
        this.commandParserProvider = commandParserProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.permission(this.permission.getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String receiverName = this.tellModule.getSenderReceiverMap().get(fPlayer.getUuid());
        if (receiverName == null) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Reply::getNullReceiver)).build());
            return;
        }
        String message = (String)this.getArgument(commandContext, 0);
        this.tellModule.send(fPlayer, receiverName, message);
    }
}

