/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.rockpaperscissors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.rockpaperscissors.model.RockPaperScissors;
import net.flectone.pulse.module.command.rockpaperscissors.model.RockPaperScissorsMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.parser.standard.UUIDParser;

@Singleton
public class RockpaperscissorsModule
extends AbstractModuleCommand<Localization.Command.Rockpaperscissors> {
    private final Map<UUID, RockPaperScissors> gameMap = new HashMap<UUID, RockPaperScissors>();
    private final Command.Rockpaperscissors command;
    private final Permission.Command.Rockpaperscissors permission;
    private final ProxySender proxySender;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final IntegrationModule integrationModule;

    @Inject
    public RockpaperscissorsModule(FileResolver fileResolver, ProxySender proxySender, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, IntegrationModule integrationModule) {
        super(localization -> localization.getCommand().getRockpaperscissors(), Command::getRockpaperscissors, fPlayer -> fPlayer.isSetting(FPlayer.Setting.ROCKPAPERSCISSORS), MessageType.COMMAND_ROCKPAPERSCISSORS);
        this.command = fileResolver.getCommand().getRockpaperscissors();
        this.permission = fileResolver.getPermission().getCommand().getRockpaperscissors();
        this.proxySender = proxySender;
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.integrationModule = integrationModule;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMove = this.addPrompt(1, Localization.Command.Prompt::getMove);
        String promptUUID = this.addPrompt(2, Localization.Command.Prompt::getId);
        this.registerCommand(manager -> manager.permission(this.permission.getName()).required(promptPlayer, this.commandParserProvider.playerParser()).optional(promptMove, this.commandParserProvider.nativeSingleMessageParser()).optional(promptUUID, UUIDParser.uuidParser()));
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.gameMap.clear();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.checkDisable(fPlayer, fPlayer, DisableSource.YOU)) {
            return;
        }
        if (this.checkMute(fPlayer)) {
            return;
        }
        String player = (String)this.getArgument(commandContext, 0);
        FPlayer fReceiver = this.fPlayerService.getFPlayer(player);
        if (!fReceiver.isOnline() || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getNullPlayer)).build());
            return;
        }
        if (fReceiver.equals(fPlayer)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getMyself)).build());
            return;
        }
        this.fPlayerService.loadIgnores(fReceiver);
        if (this.checkIgnore(fPlayer, fReceiver)) {
            return;
        }
        if (this.checkDisable(fPlayer, fReceiver, DisableSource.HE)) {
            return;
        }
        String promptMove = this.getPrompt(1);
        Optional optionalMove = commandContext.optional(promptMove);
        String move = optionalMove.orElse(null);
        String promptUUID = this.getPrompt(2);
        Optional optionalUUID = commandContext.optional(promptUUID);
        UUID uuid = optionalUUID.orElse(null);
        if (move != null && uuid != null) {
            this.finalMove(fPlayer, fReceiver, move, uuid);
            return;
        }
        RockPaperScissors rockPaperScissors = new RockPaperScissors(fPlayer.getUuid(), fReceiver.getUuid());
        this.proxySender.send(fPlayer, MessageType.COMMAND_ROCKPAPERSCISSORS, dataOutputStream -> {
            dataOutputStream.writeUTF(rockPaperScissors.getId().toString());
            dataOutputStream.writeUTF(rockPaperScissors.getReceiver().toString());
        }, UUID.randomUUID());
        this.create(rockPaperScissors.getId(), fPlayer, fReceiver.getUuid());
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((EventMetadata.EventMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().sender(fPlayer)).format(s -> StringUtils.replaceEach((String)s.getFormatMove(), (String[])new String[]{"<target>", "<uuid>"}, (String[])new String[]{fReceiver.getName(), rockPaperScissors.getId().toString()}))).rockPaperScissors(rockPaperScissors)).sound(this.getModuleSound())).build());
    }

    public void finalMove(FPlayer fPlayer, FPlayer fReceiver, String move, UUID uuid) {
        List<String> strategy = this.command.getStrategies().get(move);
        if (strategy == null) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getWrongMove)).build());
            return;
        }
        RockPaperScissors rockPaperScissors = this.gameMap.get(uuid);
        if (rockPaperScissors == null) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getNullGame)).build());
            return;
        }
        if (rockPaperScissors.getSenderMove() != null) {
            if (rockPaperScissors.getSender().equals(fPlayer.getUuid())) {
                this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getAlready)).build());
                return;
            }
            boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_ROCKPAPERSCISSORS_FINAL, dataOutputStream -> {
                dataOutputStream.writeUTF(rockPaperScissors.getId().toString());
                dataOutputStream.writeUTF(move);
            }, UUID.randomUUID());
            if (isSent) {
                return;
            }
            this.sendFinalMessage(rockPaperScissors.getId(), fPlayer, move, UUID.randomUUID());
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fReceiver)).filterPlayer(fPlayer)).format(Localization.Command.Rockpaperscissors::getSender)).build());
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_ROCKPAPERSCISSORS_MOVE, dataOutputStream -> {
            dataOutputStream.writeUTF(rockPaperScissors.getId().toString());
            dataOutputStream.writeUTF(move);
        }, UUID.randomUUID());
        if (isSent) {
            return;
        }
        this.move(rockPaperScissors.getId(), fPlayer, move, UUID.randomUUID());
    }

    public void sendFinalMessage(UUID id, FPlayer fPlayer, String move, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        RockPaperScissors rockPaperScissors = this.gameMap.get(id);
        if (rockPaperScissors == null) {
            return;
        }
        FPlayer fReceiver = this.fPlayerService.getFPlayer(rockPaperScissors.getSender());
        this.gameMap.remove(id);
        String senderMove = rockPaperScissors.getSenderMove();
        boolean isDraw = senderMove.equalsIgnoreCase(move);
        if (isDraw) {
            BiFunction<FPlayer, Localization.Command.Rockpaperscissors, String> message = (p, m) -> Strings.CS.replace(m.getFormatDraw(), "<move>", ((Localization.Command.Rockpaperscissors)this.resolveLocalization((FEntity)p)).getStrategies().get(move));
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(fPlayer)).format(message)).build());
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(fReceiver)).format(message)).build());
            return;
        }
        BiFunction<FPlayer, Localization.Command.Rockpaperscissors, String> message = (p, m) -> StringUtils.replaceEach((String)m.getFormatWin(), (String[])new String[]{"<sender_move>", "<receiver_move>"}, (String[])new String[]{((Localization.Command.Rockpaperscissors)this.resolveLocalization((FEntity)p)).getStrategies().get(senderMove), ((Localization.Command.Rockpaperscissors)this.resolveLocalization((FEntity)p)).getStrategies().get(move)});
        FPlayer winFPlayer = this.command.getStrategies().get(move).contains(senderMove) ? fPlayer : fReceiver;
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().uuid(metadataUUID)).sender(winFPlayer)).filterPlayer(fPlayer)).format(message)).rockPaperScissors(rockPaperScissors)).build());
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().uuid(metadataUUID)).sender(winFPlayer)).filterPlayer(fReceiver)).format(message)).rockPaperScissors(rockPaperScissors)).build());
    }

    public void move(UUID id, FEntity fPlayer, String move, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        RockPaperScissors rockPaperScissors = this.gameMap.get(id);
        if (rockPaperScissors == null) {
            return;
        }
        FPlayer fReceiver = this.fPlayerService.getFPlayer(rockPaperScissors.getReceiver());
        rockPaperScissors.setSenderMove(move);
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().sender(fPlayer)).filterPlayer(fReceiver, true)).format(Localization.Command.Rockpaperscissors::getReceiver)).rockPaperScissors(rockPaperScissors)).build());
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).filterPlayer(fReceiver, true)).format(s -> StringUtils.replaceEach((String)s.getFormatMove(), (String[])new String[]{"<target>", "<uuid>"}, (String[])new String[]{fPlayer.getName(), rockPaperScissors.getId().toString()}))).rockPaperScissors(rockPaperScissors)).build());
    }

    public void create(UUID id, FEntity fPlayer, UUID receiver) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        RockPaperScissors rockPaperScissors = new RockPaperScissors(id, fPlayer.getUuid(), receiver);
        this.gameMap.put(id, rockPaperScissors);
    }
}

