/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.spy;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.spy.model.SpyMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class SpyModule
extends AbstractModuleCommand<Localization.Command.Spy> {
    private final Command.Spy command;
    private final Permission.Command.Spy permission;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;

    @Inject
    public SpyModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker) {
        super((Localization localization) -> localization.getCommand().getSpy(), Command::getSpy, MessageType.COMMAND_SPY);
        this.command = fileResolver.getCommand().getSpy();
        this.permission = fileResolver.getPermission().getCommand().getSpy();
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        this.registerCommand(manager -> manager.permission(this.permission.getName()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        boolean turnedBefore = fPlayer.isSetting(FPlayer.Setting.SPY);
        if (turnedBefore) {
            this.fPlayerService.deleteSetting(fPlayer, FPlayer.Setting.SPY);
        } else {
            this.fPlayerService.saveOrUpdateSetting(fPlayer, FPlayer.Setting.SPY, "");
        }
        this.sendMessage(((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)SpyMetadata.builder().sender(fPlayer)).format(s -> !turnedBefore ? s.getFormatTrue() : s.getFormatFalse())).turned(!turnedBefore)).action("turning")).destination(this.command.getDestination())).sound(this.getModuleSound())).build());
    }

    public void checkChat(FPlayer fPlayer, String chat, String message) {
        if (!this.isEnable()) {
            return;
        }
        Map<String, List<String>> categories = this.command.getCategories();
        if (categories.get("action") == null) {
            return;
        }
        if (!categories.get("action").contains(chat)) {
            return;
        }
        this.spy(fPlayer, chat, message);
    }

    public void spy(FPlayer fPlayer, String action, String message) {
        if (!this.isEnable()) {
            return;
        }
        this.sendMessage(((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)SpyMetadata.builder().sender(fPlayer)).format(this.replaceAction(action))).turned(true)).action(action)).range(this.command.getRange())).destination(this.command.getDestination())).message(message)).filter(this.createFilter(fPlayer))).proxy(dataOutputStream -> {
            dataOutputStream.writeString(action);
            dataOutputStream.writeString(message);
        })).integration(string -> Strings.CS.replace(string, "<action>", action))).build());
    }

    private Predicate<FPlayer> createFilter(FPlayer fPlayer) {
        return fReceiver -> !fPlayer.equals((FPlayer)fReceiver) && this.permissionChecker.check((FEntity)fReceiver, this.getModulePermission()) && fReceiver.isSetting(FPlayer.Setting.SPY) && fPlayer.isOnline();
    }

    public Function<Localization.Command.Spy, String> replaceAction(String action) {
        return message -> Strings.CS.replace(message.getFormatLog(), "<action>", action);
    }
}

