/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.stream;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.stream.listener.StreamPulseListener;
import net.flectone.pulse.module.command.stream.model.StreamMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class StreamModule
extends AbstractModuleCommand<Localization.Command.Stream>
implements PulseListener {
    private final Command.Stream command;
    private final Permission.Command.Stream permission;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public StreamModule(FileResolver fileResolver, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getCommand().getStream(), Command::getStream, MessageType.COMMAND_STREAM);
        this.command = fileResolver.getCommand().getStream();
        this.permission = fileResolver.getPermission().getCommand().getStream();
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptType = this.addPrompt(0, Localization.Command.Prompt::getType);
        String promptUrl = this.addPrompt(1, Localization.Command.Prompt::getUrl);
        this.registerCommand(manager -> manager.permission(this.permission.getName()).required(promptType, this.commandParserProvider.singleMessageParser(), this.typeSuggestion()).optional(promptUrl, this.commandParserProvider.nativeMessageParser()));
        this.listenerRegistry.register(StreamPulseListener.class);
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> typeSuggestion() {
        return (context, input) -> List.of(Suggestion.suggestion((String)"start"), Suggestion.suggestion((String)"end"));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        Boolean needStart;
        String type;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.checkDisable(fPlayer, fPlayer, DisableSource.YOU)) {
            return;
        }
        if (this.checkMute(fPlayer)) {
            return;
        }
        switch (type = (String)this.getArgument(commandContext, 0)) {
            case "start": {
                Boolean bl = true;
                break;
            }
            case "end": {
                Boolean bl = false;
                break;
            }
            default: {
                Boolean bl = needStart = null;
            }
        }
        if (needStart == null) {
            return;
        }
        boolean isStream = fPlayer.isSetting(FPlayer.Setting.STREAM);
        if (isStream && needStart.booleanValue() && !fPlayer.isUnknown()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Stream::getAlready)).build());
            return;
        }
        if (!isStream && !needStart.booleanValue()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Stream::getNot)).build());
            return;
        }
        this.setStreamPrefix(fPlayer, needStart);
        if (needStart.booleanValue()) {
            String promptUrl = this.getPrompt(1);
            Optional optionalUrl = commandContext.optional(promptUrl);
            String rawString = optionalUrl.orElse("");
            String urls = Arrays.stream(rawString.split("\\s+")).filter(this::isUrl).collect(Collectors.joining(" "));
            this.sendMessage(((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((EventMetadata.EventMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)StreamMetadata.builder().sender(fPlayer)).format(this.replaceUrls(urls))).turned(true)).urls(urls)).range(this.command.getRange())).destination(this.command.getDestination())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeString(urls))).integration(string -> Strings.CS.replace(string, "<urls>", StringUtils.defaultString((String)urls)))).build());
        } else {
            this.sendMessage(((StreamMetadata.StreamMetadataBuilder)((EventMetadata.EventMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)StreamMetadata.builder().sender(fPlayer)).format(Localization.Command.Stream::getFormatEnd)).turned(false)).destination(this.command.getDestination())).build());
        }
    }

    public void addTag(MessageContext messageContext) {
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (!(sender instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.STREAM_PREFIX, (argumentQueue, context) -> {
            String streamPrefix = fPlayer.getSettingValue(FPlayer.Setting.STREAM_PREFIX);
            if (StringUtils.isEmpty((CharSequence)streamPrefix)) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            return Tag.preProcessParsed((String)streamPrefix);
        });
    }

    public Function<Localization.Command.Stream, String> replaceUrls(String string) {
        return message -> {
            List<String> urls = Arrays.stream(string.split(" ")).map(url -> Strings.CS.replace(message.getUrlTemplate(), "<url>", url)).toList();
            return Strings.CS.replace(message.getFormatStart(), "<urls>", String.join((CharSequence)"<br>", urls));
        };
    }

    public void setStreamPrefix(FPlayer fPlayer, boolean isStart) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (fPlayer.isUnknown()) {
            return;
        }
        if (isStart) {
            this.fPlayerService.saveOrUpdateSetting(fPlayer, FPlayer.Setting.STREAM, "");
            this.fPlayerService.saveOrUpdateSetting(fPlayer, FPlayer.Setting.STREAM_PREFIX, ((Localization.Command.Stream)this.resolveLocalization()).getPrefixTrue());
            return;
        }
        this.fPlayerService.deleteSetting(fPlayer, FPlayer.Setting.STREAM);
        this.fPlayerService.saveOrUpdateSetting(fPlayer, FPlayer.Setting.STREAM_PREFIX, ((Localization.Command.Stream)this.resolveLocalization()).getPrefixFalse());
    }

    private boolean isUrl(String string) {
        try {
            new URL(string).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }
}

