/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.symbol;

import java.util.Arrays;
import java.util.Collections;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class SymbolModule
extends AbstractModuleCommand<Localization.Command.Symbol> {
    private final Command.Symbol command;
    private final Permission.Command.Symbol permission;
    private final CommandParserProvider commandParserProvider;

    @Inject
    public SymbolModule(FileResolver fileResolver, CommandParserProvider commandParserProvider) {
        super(localization -> localization.getCommand().getSymbol(), Command::getSymbol, MessageType.COMMAND_SYMBOL);
        this.command = fileResolver.getCommand().getSymbol();
        this.permission = fileResolver.getPermission().getCommand().getSymbol();
        this.commandParserProvider = commandParserProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptCategory = this.addPrompt(0, Localization.Command.Prompt::getCategory);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.required(promptCategory, this.commandParserProvider.singleMessageParser(), this.categorySuggestion()).required(promptMessage, this.commandParserProvider.messageParser(), this.symbolSuggestion()).permission(this.permission.getName()));
        this.addPredicate(this::checkCooldown);
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> categorySuggestion() {
        return (context, input) -> this.command.getCategories().keySet().stream().map(Suggestion::suggestion).toList();
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> symbolSuggestion() {
        return (context, input) -> {
            String inputString = input.input();
            String[] words = inputString.split(" ");
            if (words.length < 2) {
                return Collections.emptyList();
            }
            String category = words[1];
            if (!this.command.getCategories().containsKey(category)) {
                return Collections.emptyList();
            }
            String rawInput = inputString.substring(words[0].length() + words[1].length() + 2);
            String[] symbols = this.command.getCategories().get(category).split(" ");
            return Arrays.stream(symbols).map(symbol -> Suggestion.suggestion((String)(rawInput + symbol))).toList();
        };
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String message = (String)this.getArgument(commandContext, 1);
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(s -> Strings.CS.replace(s.getFormat(), "<message>", message))).destination(this.command.getDestination())).message(message)).sound(this.getModuleSound())).build());
    }
}

