/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.tell;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class TellModule
extends AbstractModuleCommand<Localization.Command.Tell> {
    private final HashMap<UUID, String> senderReceiverMap = new HashMap();
    private final Command.Tell command;
    private final Permission.Command.Tell permission;
    private final FPlayerService fPlayerService;
    private final ProxySender proxySender;
    private final IntegrationModule integrationModule;
    private final CommandParserProvider commandParserProvider;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Inject
    public TellModule(FileResolver fileResolver, FPlayerService fPlayerService, ProxySender proxySender, IntegrationModule integrationModule, CommandParserProvider commandParserProvider, PlatformPlayerAdapter platformPlayerAdapter) {
        super(localization -> localization.getCommand().getTell(), Command::getTell, fPlayer -> fPlayer.isSetting(FPlayer.Setting.TELL), MessageType.COMMAND_TELL);
        this.command = fileResolver.getCommand().getTell();
        this.permission = fileResolver.getPermission().getCommand().getTell();
        this.fPlayerService = fPlayerService;
        this.proxySender = proxySender;
        this.integrationModule = integrationModule;
        this.commandParserProvider = commandParserProvider;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.required(promptPlayer, this.commandParserProvider.playerParser(this.command.isSuggestOfflinePlayers())).required(promptMessage, this.commandParserProvider.nativeMessageParser()).permission(this.permission.getName()));
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.senderReceiverMap.clear();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.checkDisable(fPlayer, fPlayer, DisableSource.YOU)) {
            return;
        }
        if (this.checkMute(fPlayer)) {
            return;
        }
        String playerName = (String)this.getArgument(commandContext, 0);
        String message = (String)this.getArgument(commandContext, 1);
        this.send(fPlayer, playerName, message);
    }

    public void send(FPlayer fPlayer, String playerName, String message) {
        UUID metadataUUID;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (fPlayer.getName().equalsIgnoreCase(playerName)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tell::getMyself)).destination(this.command.getDestination())).message(message)).build());
            return;
        }
        Range range = this.command.getRange();
        FPlayer fReceiver = this.fPlayerService.getFPlayer(playerName);
        if (fReceiver.isUnknown() || !fReceiver.isOnline() || !this.rangeFilter(fPlayer, range).test(fReceiver) || !range.is(Range.Type.PROXY) && !this.platformPlayerAdapter.isOnline(fReceiver)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tell::getNullPlayer)).build());
            return;
        }
        this.fPlayerService.loadIgnores(fPlayer);
        if (this.checkIgnore(fPlayer, fReceiver)) {
            return;
        }
        if (this.checkDisable(fPlayer, fReceiver, DisableSource.HE)) {
            return;
        }
        String receiverUUID = fReceiver.getUuid().toString();
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_TELL, dataOutputStream -> {
            dataOutputStream.writeUTF(receiverUUID);
            dataOutputStream.writeUTF(message);
        }, metadataUUID = UUID.randomUUID());
        if (isSent) {
            this.send(fReceiver, fPlayer, Localization.Command.Tell::getSender, message, false, metadataUUID);
            return;
        }
        FPlayer fNewReceiver = this.fPlayerService.getFPlayer(fReceiver.getUuid());
        if (!this.integrationModule.canSeeVanished(fNewReceiver, fPlayer)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tell::getNullPlayer)).build());
            return;
        }
        this.send(fPlayer, fNewReceiver, Localization.Command.Tell::getReceiver, message, true, UUID.randomUUID());
        this.send(fNewReceiver, fPlayer, Localization.Command.Tell::getSender, message, false, UUID.randomUUID());
    }

    public void send(FEntity fPlayer, FPlayer fReceiver, Function<Localization.Command.Tell, String> format, String string, boolean senderColorOut, UUID metadataUUID) {
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(fPlayer)).filterPlayer(fReceiver, senderColorOut)).format(format)).destination(this.command.getDestination())).message(string)).sound(senderColorOut ? this.getModuleSound() : null)).build());
        this.senderReceiverMap.put(fReceiver.getUuid(), fPlayer.getName());
    }

    @Generated
    public HashMap<UUID, String> getSenderReceiverMap() {
        return this.senderReceiverMap;
    }
}

