/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.tictactoe;

import com.google.gson.Gson;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.tictactoe.manager.TictactoeManager;
import net.flectone.pulse.module.command.tictactoe.model.TicTacToe;
import net.flectone.pulse.module.command.tictactoe.model.TicTacToeMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class TictactoeModule
extends AbstractModuleCommand<Localization.Command.Tictactoe> {
    private final Command.Tictactoe command;
    private final Permission.Command.Tictactoe permission;
    private final FPlayerService fPlayerService;
    private final TictactoeManager tictactoeManager;
    private final ProxySender proxySender;
    private final IntegrationModule integrationModule;
    private final CommandParserProvider commandParserProvider;
    private final Gson gson;

    @Inject
    public TictactoeModule(FileResolver fileResolver, FPlayerService fPlayerService, TictactoeManager tictactoeManager, ProxySender proxySender, IntegrationModule integrationModule, CommandParserProvider commandParserProvider, Gson gson) {
        super(localization -> localization.getCommand().getTictactoe(), Command::getTictactoe, fPlayer -> fPlayer.isSetting(FPlayer.Setting.TICTACTOE), MessageType.COMMAND_TICTACTOE);
        this.command = fileResolver.getCommand().getTictactoe();
        this.permission = fileResolver.getPermission().getCommand().getTictactoe();
        this.fPlayerService = fPlayerService;
        this.tictactoeManager = tictactoeManager;
        this.proxySender = proxySender;
        this.integrationModule = integrationModule;
        this.commandParserProvider = commandParserProvider;
        this.gson = gson;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptHard = this.addPrompt(1, Localization.Command.Prompt::getHard);
        this.registerCommand(manager -> manager.required(promptPlayer, this.commandParserProvider.playerParser()).optional(promptHard, this.commandParserProvider.booleanParser()).permission(this.permission.getName()));
        String promptId = this.addPrompt(2, Localization.Command.Prompt::getId);
        String promptMove = this.addPrompt(3, Localization.Command.Prompt::getMove);
        this.registerCustomCommand(manager -> manager.commandBuilder(this.getCommandName() + "move", new String[0]).required(promptId, this.commandParserProvider.integerParser()).required(promptMove, this.commandParserProvider.singleMessageParser()).permission(this.permission.getName()).handler(commandContext -> this.executeMove((FPlayer)commandContext.sender(), (CommandContext<FPlayer>)commandContext)));
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.tictactoeManager.clear();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        if (this.checkDisable(fPlayer, fPlayer, DisableSource.YOU)) {
            return;
        }
        if (this.checkMute(fPlayer)) {
            return;
        }
        String receiverName = (String)this.getArgument(commandContext, 0);
        String promptHard = this.getPrompt(1);
        Optional optionalBoolean = commandContext.optional(promptHard);
        boolean isHard = optionalBoolean.orElse(true);
        FPlayer fReceiver = this.fPlayerService.getFPlayer(receiverName);
        if (!fReceiver.isOnline() || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getNullPlayer)).build());
            return;
        }
        if (fReceiver.equals(fPlayer)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getMyself)).build());
            return;
        }
        this.fPlayerService.loadIgnores(fPlayer);
        if (this.checkIgnore(fPlayer, fReceiver)) {
            return;
        }
        if (this.checkDisable(fPlayer, fReceiver, DisableSource.HE)) {
            return;
        }
        TicTacToe ticTacToe = this.tictactoeManager.create(fPlayer, fReceiver, isHard);
        this.sendMessage(((TicTacToeMetadata.TicTacToeMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)TicTacToeMetadata.builder().sender(fReceiver)).filterPlayer(fPlayer)).format(Localization.Command.Tictactoe::getSender)).ticTacToe(ticTacToe)).sound(this.getModuleSound())).build());
        UUID metadataUUID = UUID.randomUUID();
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_TICTACTOE, dataOutputStream -> {
            dataOutputStream.writeUTF(this.gson.toJson((Object)fReceiver));
            dataOutputStream.writeInt(ticTacToe.getId());
            dataOutputStream.writeBoolean(isHard);
        }, metadataUUID);
        if (isSent) {
            return;
        }
        this.sendCreateMessage(fPlayer, fReceiver, ticTacToe, metadataUUID);
    }

    public void sendCreateMessage(FPlayer fPlayer, FPlayer fReceiver, TicTacToe ticTacToe, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!this.integrationModule.canSeeVanished(fPlayer, fReceiver) || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            return;
        }
        this.sendMessage(((TicTacToeMetadata.TicTacToeMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)TicTacToeMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).filterPlayer(fReceiver, true)).format(message -> String.format(message.getReceiver(), ticTacToe.getId()))).ticTacToe(ticTacToe)).sound(this.getModuleSound())).build());
    }

    public void sendMoveMessage(FPlayer fPlayer, FPlayer fReceiver, TicTacToe ticTacToe, int typeTitle, String move, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!this.integrationModule.canSeeVanished(fPlayer, fReceiver) || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            return;
        }
        if (ticTacToe == null) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fReceiver)).filterPlayer(fPlayer, true)).format(this.getMoveMessage(ticTacToe, fReceiver, typeTitle, move))).build());
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(fReceiver)).filterPlayer(fReceiver)).format(this.getMoveMessage(ticTacToe, fReceiver, typeTitle, move))).build());
    }

    public void executeMove(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        int typeTitle;
        int tictactoeID = (Integer)this.getArgument(commandContext, 2);
        String move = (String)this.getArgument(commandContext, 3);
        TicTacToe ticTacToe = this.tictactoeManager.get(tictactoeID);
        if (ticTacToe == null || ticTacToe.isEnded() || !ticTacToe.contains(fPlayer) || move.equals("create") && ticTacToe.isCreated()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getWrongGame)).build());
            return;
        }
        if (!ticTacToe.move(fPlayer, move)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getWrongMove)).build());
            return;
        }
        FPlayer fReceiver = this.fPlayerService.getFPlayer(ticTacToe.getNextPlayer());
        if (!fReceiver.isOnline() || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            ticTacToe.setEnded(true);
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getWrongByPlayer)).build());
            return;
        }
        if (ticTacToe.isWin()) {
            ticTacToe.setEnded(true);
            typeTitle = 1;
            tempFPlayer = fPlayer;
            fPlayer = fReceiver;
            fReceiver = tempFPlayer;
        } else if (ticTacToe.isDraw()) {
            ticTacToe.setEnded(true);
            typeTitle = -1;
            tempFPlayer = fPlayer;
            fPlayer = fReceiver;
            fReceiver = tempFPlayer;
        } else {
            typeTitle = 0;
        }
        FPlayer finalFReceiver = fReceiver;
        UUID metadataUUID = UUID.randomUUID();
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_TICTACTOE_MOVE, dataOutputStream -> {
            dataOutputStream.writeUTF(this.gson.toJson((Object)finalFReceiver));
            dataOutputStream.writeUTF(ticTacToe.toString());
            dataOutputStream.writeInt(typeTitle);
            dataOutputStream.writeUTF(move);
        }, metadataUUID);
        if (isSent) {
            return;
        }
        this.sendMoveMessage(fPlayer, finalFReceiver, ticTacToe, typeTitle, move, metadataUUID);
    }

    public BiFunction<FPlayer, Localization.Command.Tictactoe, String> getMoveMessage(TicTacToe ticTacToe, FPlayer fPlayer, int typeTile, String move) {
        return (fResolver, message) -> {
            String title = switch (typeTile) {
                case 1 -> message.getFormatWin();
                case -1 -> message.getFormatDraw();
                default -> message.getFormatMove();
            };
            Localization.Command.Tictactoe.Symbol messageSymbol = message.getSymbol();
            String symbolFirst = messageSymbol.getFirst();
            String symbolSecond = messageSymbol.getSecond();
            String formatField = StringUtils.replaceEach((String)String.join((CharSequence)"<br>", message.getField()), (String[])new String[]{"<current_move>", "<last_move>"}, (String[])new String[]{ticTacToe.isEnded() ? "" : message.getCurrentMove(), message.getLastMove()});
            formatField = StringUtils.replaceEach((String)formatField, (String[])new String[]{"<title>", "<symbol>", "<move>"}, (String[])new String[]{title, ticTacToe.getFirstPlayer() == fPlayer.getId() ? symbolFirst : symbolSecond, move});
            String symbolEmpty = messageSymbol.getBlank();
            String symbolFirstRemove = messageSymbol.getFirstRemove();
            String symbolFirstWin = messageSymbol.getFirstWin();
            String symbolSecondRemove = messageSymbol.getSecondRemove();
            String symbolSecondWin = messageSymbol.getSecondWin();
            return ticTacToe.build(formatField, symbolFirst, symbolFirstRemove, symbolFirstWin, symbolSecond, symbolSecondRemove, symbolSecondWin, String.format(symbolEmpty, ticTacToe.getId()));
        };
    }
}

