/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.translateto;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.translateto.model.TranslatetoMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.translate.TranslateModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.DisableSource;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class TranslatetoModule
extends AbstractModuleCommand<Localization.Command.Translateto> {
    private final Command.Translateto command;
    private final Permission.Command.Translateto permission;
    private final CommandParserProvider commandParserProvider;
    private final IntegrationModule integrationModule;
    private final Provider<TranslateModule> translateModuleProvider;

    @Inject
    public TranslatetoModule(FileResolver fileResolver, CommandParserProvider commandParserProvider, IntegrationModule integrationModule, Provider<TranslateModule> translateModuleProvider) {
        super((Localization localization) -> localization.getCommand().getTranslateto(), Command::getTranslateto, (FPlayer fPlayer) -> fPlayer.isSetting(FPlayer.Setting.TRANSLATETO), MessageType.COMMAND_TRANSLATETO);
        this.command = fileResolver.getCommand().getTranslateto();
        this.permission = fileResolver.getPermission().getCommand().getTranslateto();
        this.commandParserProvider = commandParserProvider;
        this.integrationModule = integrationModule;
        this.translateModuleProvider = translateModuleProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptLanguage = this.addPrompt(0, Localization.Command.Prompt::getLanguage);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.required(promptLanguage + " main", this.commandParserProvider.singleMessageParser(), this.languageSuggestion()).required(promptLanguage + " target", this.commandParserProvider.singleMessageParser(), this.languageSuggestion()).required(promptMessage, this.commandParserProvider.nativeMessageParser()).permission(this.permission.getName()));
        this.addPredicate(this::checkCooldown);
        this.addPredicate(fPlayer -> this.checkDisable((FEntity)fPlayer, (FEntity)fPlayer, DisableSource.YOU));
        this.addPredicate(this::checkMute);
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> languageSuggestion() {
        return (context, input) -> this.command.getLanguages().stream().map(Suggestion::suggestion).toList();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        String translatedMessage;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String promptLanguage = this.getPrompt(0);
        String mainLang = (String)commandContext.get(promptLanguage + " main");
        String targetLang = (String)commandContext.get(promptLanguage + " target");
        String message = (String)this.getArgument(commandContext, 1);
        String messageToTranslate = ((TranslateModule)this.translateModuleProvider.get()).getMessage(message);
        if (StringUtils.isEmpty((CharSequence)messageToTranslate)) {
            messageToTranslate = message;
        }
        if ((translatedMessage = this.translate(fPlayer, mainLang, targetLang, messageToTranslate)).isEmpty()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Translateto::getNullOrError)).build());
            return;
        }
        String finalMessageToTranslate = messageToTranslate;
        this.sendMessage(((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)TranslatetoMetadata.builder().sender(fPlayer)).format(this.replaceLanguage(targetLang))).targetLanguage(targetLang)).messageToTranslate(messageToTranslate)).range(this.command.getRange())).destination(this.command.getDestination())).message(translatedMessage)).sound(this.getModuleSound())).proxy(dataOutputStream -> {
            dataOutputStream.writeString(targetLang);
            dataOutputStream.writeString(message);
            dataOutputStream.writeString(finalMessageToTranslate);
        })).integration(string -> Strings.CS.replace(string, "<language>", targetLang))).build());
    }

    public Function<Localization.Command.Translateto, String> replaceLanguage(String targetLang) {
        return message -> Strings.CS.replace(message.getFormat(), "<language>", targetLang);
    }

    public String translate(FPlayer fPlayer, String source, String target, String text) {
        return switch (this.command.getService()) {
            default -> throw new MatchException(null, null);
            case Command.Translateto.Service.DEEPL -> this.integrationModule.deeplTranslate(fPlayer, source, target, text);
            case Command.Translateto.Service.GOOGLE -> this.googleTranslate(source, target, text);
            case Command.Translateto.Service.YANDEX -> this.integrationModule.yandexTranslate(fPlayer, source, target, text);
        };
    }

    public String googleTranslate(String source, String lang, String text) {
        try {
            String inputLine;
            text = URLEncoder.encode(text, StandardCharsets.UTF_8);
            URL url = new URL("http://translate.googleapis.com/translate_a/single?client=gtx&sl=" + source + "&tl=" + lang + "&dt=t&q=" + text + "&ie=UTF-8&oe=UTF-8");
            URLConnection uc = url.openConnection();
            uc.setRequestProperty("User-Agent", "Mozilla/5.0");
            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream(), StandardCharsets.UTF_8));
            while ((inputLine = in.readLine()) != null) {
                text = inputLine;
            }
            in.close();
            String jsonResponse = text;
            int startIndex = jsonResponse.indexOf("\"") + 1;
            int endIndex = jsonResponse.indexOf("\"", startIndex);
            return jsonResponse.substring(startIndex, endIndex);
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

