/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.unban;

import java.util.ArrayList;
import java.util.Optional;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.UnModerationMetadata;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class UnbanModule
extends AbstractModuleCommand<Localization.Command.Unban> {
    private final Command.Unban command;
    private final Permission.Command.Unban permission;
    private final FPlayerService fPlayerService;
    private final ModerationService moderationService;
    private final CommandParserProvider commandParserProvider;
    private final ProxySender proxySender;

    @Inject
    public UnbanModule(FileResolver fileResolver, FPlayerService fPlayerService, ModerationService moderationService, CommandParserProvider commandParserProvider, ProxySender proxySender) {
        super(localization -> localization.getCommand().getUnban(), Command::getUnban, MessageType.COMMAND_UNBAN);
        this.command = fileResolver.getCommand().getUnban();
        this.permission = fileResolver.getPermission().getCommand().getUnban();
        this.fPlayerService = fPlayerService;
        this.moderationService = moderationService;
        this.commandParserProvider = commandParserProvider;
        this.proxySender = proxySender;
    }

    @Override
    protected boolean isConfigEnable() {
        return this.command.isEnable();
    }

    @Override
    public void onEnable() {
        if (this.isModuleDisabledFor(FPlayer.UNKNOWN)) {
            return;
        }
        this.registerModulePermission(this.permission);
        this.createCooldown(this.command.getCooldown(), this.permission.getCooldownBypass());
        this.createSound(this.command.getSound(), this.permission.getSound());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptId = this.addPrompt(1, Localization.Command.Prompt::getId);
        this.registerCommand(manager -> manager.permission(this.permission.getName()).required(promptPlayer, this.commandParserProvider.bannedParser()).optional(promptId, this.commandParserProvider.integerParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.checkCooldown(fPlayer)) {
            return;
        }
        String target = (String)this.getArgument(commandContext, 0);
        String promptId = this.getPrompt(1);
        Optional optionalId = commandContext.optional(promptId);
        int id = optionalId.orElse(-1);
        this.unban(fPlayer, target, id);
    }

    public void unban(FPlayer fPlayer, String target, int id) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(target);
        if (fTarget.isUnknown()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Unban::getNullPlayer)).build());
            return;
        }
        ArrayList<Moderation> bans = new ArrayList<Moderation>();
        if (id == -1) {
            bans.addAll(this.moderationService.getValidBans(fTarget));
        } else {
            this.moderationService.getValidBans(fTarget).stream().filter(moderation -> moderation.getId() == id).findAny().ifPresent(bans::add);
        }
        if (bans.isEmpty()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Unban::getNotBanned)).build());
            return;
        }
        this.moderationService.remove(fTarget, bans);
        this.proxySender.send(fTarget, MessageType.SYSTEM_BAN);
        this.sendMessage(((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)UnModerationMetadata.builder().sender(fTarget)).format(unwarn -> Strings.CS.replace(unwarn.getFormat(), "<moderator>", fPlayer.getName()))).moderator(fPlayer)).moderations(bans)).destination(this.command.getDestination())).range(this.command.getRange())).sound(this.getModuleSound())).filter(filter -> filter.isSetting(FPlayer.Setting.BAN))).proxy(dataOutputStream -> {
            dataOutputStream.writeAsJson(fPlayer);
            dataOutputStream.writeAsJson(bans);
        })).integration(string -> Strings.CS.replace(string, "<moderator>", fPlayer.getName()))).build());
    }
}

