/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration;

import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.integration.miniplaceholders.MiniPlaceholdersModule;
import net.flectone.pulse.module.integration.placeholderapi.PlaceholderAPIModule;
import net.flectone.pulse.module.integration.supervanish.VanishModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;

@Singleton
public class FabricIntegrationModule
extends IntegrationModule {
    private final Provider<PermissionChecker> permissionCheckerProvider;
    private final Injector injector;

    @Inject
    public FabricIntegrationModule(FileResolver fileManager, FLogger fLogger, PlatformServerAdapter platformServerAdapter, Provider<PermissionChecker> permissionCheckerProvider, ReflectionResolver reflectionResolver, Injector injector) {
        super(fileManager, fLogger, platformServerAdapter, reflectionResolver, injector);
        this.permissionCheckerProvider = permissionCheckerProvider;
        this.injector = injector;
        if (platformServerAdapter.hasProject("melius-vanish")) {
            this.addChildren(VanishModule.class);
        }
        if (platformServerAdapter.hasProject("MiniPlaceholders")) {
            this.addChildren(MiniPlaceholdersModule.class);
        }
        if (platformServerAdapter.hasProject("placeholder-api")) {
            this.addChildren(PlaceholderAPIModule.class);
        }
    }

    @Override
    public String checkMention(FEntity fPlayer, String message) {
        return message;
    }

    @Override
    public boolean isVanished(FEntity sender) {
        if (this.getChildren().contains(VanishModule.class)) {
            return ((VanishModule)this.injector.getInstance(VanishModule.class)).isVanished(sender);
        }
        return false;
    }

    @Override
    public boolean hasSeeVanishPermission(FEntity sender) {
        return ((PermissionChecker)this.permissionCheckerProvider.get()).check(sender, "vanish.feature.view");
    }

    @Override
    public boolean sendMessageWithInteractiveChat(FEntity fReceiver, Component message) {
        return false;
    }

    @Override
    public boolean isMuted(FPlayer fPlayer) {
        return false;
    }

    @Override
    public ExternalModeration getMute(FPlayer fPlayer) {
        return null;
    }

    @Override
    public String getTritonLocale(FPlayer fPlayer) {
        return null;
    }
}

