/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.deepl;

import com.deepl.api.DeepLClient;
import com.deepl.api.DeepLClientOptions;
import com.deepl.api.DeepLException;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class DeeplIntegration
implements FIntegration {
    private final Integration.Deepl integration;
    private final FLogger fLogger;
    private DeepLClient client;

    @Inject
    public DeeplIntegration(FileResolver fileResolver, FLogger fLogger) {
        this.integration = fileResolver.getIntegration().getDeepl();
        this.fLogger = fLogger;
    }

    public String translate(String source, String target, String text) {
        try {
            return this.client.translateText(text, source.equals("auto") ? null : source, target).getText();
        }
        catch (DeepLException | InterruptedException e) {
            this.fLogger.warning(e);
            return text;
        }
    }

    @Override
    public void hook() {
        try {
            this.client = new DeepLClient(this.integration.getAuthKey(), new DeepLClientOptions());
            this.fLogger.info("\u2714 Deepl integration enabled");
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 Deepl integration disabled");
    }
}

