/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.deepl;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.deepl.DeeplIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;

@Singleton
public class DeeplModule
extends AbstractModule {
    private final Integration.Deepl integration;
    private final Permission.Integration.Deepl permission;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Inject
    public DeeplModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector) {
        this.integration = fileResolver.getIntegration().getDeepl();
        this.permission = fileResolver.getPermission().getIntegration().getDeepl();
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.reflectionResolver.hasClassOrElse("com.deepl.api.DeepLClient", this::loadLibraries);
        ((DeeplIntegration)this.injector.getInstance(DeeplIntegration.class)).hook();
    }

    @Override
    public void onDisable() {
        ((DeeplIntegration)this.injector.getInstance(DeeplIntegration.class)).unhook();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}deepl{}api").artifactId("deepl-java").version("1.10.3").resolveTransitiveDependencies(true).build());
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }

    public String translate(FPlayer sender, String source, String target, String text) {
        if (this.isModuleDisabledFor(sender)) {
            return text;
        }
        return ((DeeplIntegration)this.injector.getInstance(DeeplIntegration.class)).translate(source, target, text);
    }
}

