/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.discord;

import discord4j.common.util.Snowflake;
import discord4j.core.DiscordClient;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.object.presence.Activity;
import discord4j.core.object.presence.ClientActivity;
import discord4j.core.object.presence.ClientPresence;
import discord4j.core.object.presence.Status;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.WebhookCreateSpec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.ImmutableWebhookExecuteRequest;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.Image;
import discord4j.rest.util.MultipartRequest;
import java.awt.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.apache.lang3.math.NumberUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.discord.listener.MessageCreateListener;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

@Singleton
public class DiscordIntegration
implements FIntegration {
    private final List<Long> webhooks = new ArrayList<Long>();
    private final Integration.Discord integration;
    private final FileResolver fileResolver;
    private final TaskScheduler taskScheduler;
    private final SkinService skinService;
    private final MessageCreateListener messageCreateListener;
    private final MessagePipeline messagePipeline;
    private final SystemVariableResolver systemVariableResolver;
    private final FLogger fLogger;
    private DiscordClient discordClient;
    private GatewayDiscordClient gateway;
    private long clientID;

    @Inject
    public DiscordIntegration(FileResolver fileResolver, TaskScheduler taskScheduler, SkinService skinService, MessagePipeline messagePipeline, SystemVariableResolver systemVariableResolver, MessageCreateListener messageCreateListener, FLogger fLogger) {
        this.integration = fileResolver.getIntegration().getDiscord();
        this.fileResolver = fileResolver;
        this.taskScheduler = taskScheduler;
        this.skinService = skinService;
        this.messagePipeline = messagePipeline;
        this.systemVariableResolver = systemVariableResolver;
        this.messageCreateListener = messageCreateListener;
        this.fLogger = fLogger;
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> discordString) {
        if (this.gateway == null) {
            return;
        }
        String integrationChannel = this.integration.getMessageChannel().get(messageName);
        if (integrationChannel == null) {
            return;
        }
        if (integrationChannel.isEmpty()) {
            return;
        }
        Localization.Integration.Discord localization = this.fileResolver.getLocalization().getIntegration().getDiscord();
        Localization.Integration.Discord.ChannelEmbed messageChannelEmbed = localization.getMessageChannel().get(messageName);
        if (messageChannelEmbed == null) {
            return;
        }
        String skin = this.skinService.getSkin(sender);
        UnaryOperator replaceString = s -> Strings.CS.replace((String)discordString.apply((String)s), "<skin>", skin);
        EmbedCreateSpec embed = null;
        if (messageChannelEmbed.getEmbed().isEnable()) {
            embed = this.createEmbed(messageChannelEmbed, replaceString);
        }
        Localization.Integration.Discord.Webhook messageWebhook = messageChannelEmbed.getWebhook();
        if (messageChannelEmbed.getWebhook().isEnable()) {
            long channelID = Snowflake.of((String)integrationChannel).asLong();
            WebhookData webhookPlayerData = (WebhookData)this.discordClient.getWebhookService().getChannelWebhooks(channelID).filter(webhookData -> webhookData.name().isPresent() && ((String)webhookData.name().get()).equals(sender.getName())).blockFirst();
            if (webhookPlayerData == null) {
                String avatarURL = (String)replaceString.apply(messageWebhook.getAvatar());
                webhookPlayerData = this.createWebhook(avatarURL, sender.getName(), channelID);
            }
            if (webhookPlayerData == null) {
                return;
            }
            long webhookID = webhookPlayerData.id().asLong();
            if (!this.webhooks.contains(webhookID) && webhookPlayerData.applicationId().isPresent() && ((Id)webhookPlayerData.applicationId().get()).asLong() == this.clientID) {
                this.webhooks.add(webhookID);
                this.deleteWebhookLater(webhookID);
            }
            ImmutableWebhookExecuteRequest.Builder webhookBuilder = WebhookExecuteRequest.builder().allowedMentions((AllowedMentionsData)AllowedMentionsData.builder().build());
            if (embed != null) {
                webhookBuilder.addEmbed(embed.asRequest());
            }
            webhookBuilder.content((String)replaceString.apply(messageWebhook.getContent()));
            this.discordClient.getWebhookService().executeWebhook(webhookPlayerData.id().asLong(), (String)webhookPlayerData.token().get(), false, MultipartRequest.ofRequest((Object)webhookBuilder.build())).subscribe();
            return;
        }
        MessageCreateSpec.Builder messageCreateSpecBuilder = MessageCreateSpec.builder().allowedMentions(AllowedMentions.suppressAll());
        if (embed != null) {
            messageCreateSpecBuilder.addEmbed(embed);
        }
        String content = (String)replaceString.apply(messageChannelEmbed.getContent());
        messageCreateSpecBuilder.content(content);
        this.discordClient.getChannelById(Snowflake.of((String)integrationChannel)).createMessage(messageCreateSpecBuilder.build().asRequest()).subscribe();
    }

    @Async(delay=1200L)
    public void deleteWebhookLater(long webhookID) {
        this.discordClient.getWebhookService().deleteWebhook(webhookID, null).subscribe();
        this.webhooks.remove(webhookID);
    }

    private WebhookData createWebhook(String avatarURL, String fPlayerName, long channelID) {
        WebhookCreateSpec webhook = WebhookCreateSpec.builder().avatarOrNull((Image)Image.ofUrl((String)avatarURL).block()).name(fPlayerName).build();
        return (WebhookData)this.discordClient.getWebhookService().createWebhook(channelID, webhook.asRequest(), null).block();
    }

    private EmbedCreateSpec createEmbed(Localization.Integration.Discord.ChannelEmbed localizationChannel, UnaryOperator<String> discordString) {
        Localization.Integration.Discord.Embed.Footer footer;
        Localization.Integration.Discord.Embed.Author author;
        Localization.Integration.Discord.Embed embed = localizationChannel.getEmbed();
        if (!embed.isEnable()) {
            return null;
        }
        EmbedCreateSpec.Builder embedBuilder = EmbedCreateSpec.builder();
        if (!embed.getColor().isEmpty()) {
            Color color = Color.decode(embed.getColor());
            embedBuilder.color(discord4j.rest.util.Color.of((int)color.getRGB()));
        }
        if (!embed.getTitle().isEmpty()) {
            embedBuilder.title((String)discordString.apply(embed.getTitle()));
        }
        if (!embed.getUrl().isEmpty()) {
            embedBuilder.url((String)discordString.apply(embed.getUrl()));
        }
        if (!((author = embed.getAuthor()).getName().isEmpty() && author.getUrl().isEmpty() && author.getIconUrl().isEmpty())) {
            embedBuilder.author((String)discordString.apply(author.getName()), (String)discordString.apply(author.getUrl()), (String)discordString.apply(author.getIconUrl()));
        }
        if (!embed.getDescription().isEmpty()) {
            embedBuilder.description((String)discordString.apply(embed.getDescription()));
        }
        if (!embed.getThumbnail().isEmpty()) {
            embedBuilder.thumbnail((String)discordString.apply(embed.getThumbnail()));
        }
        if (!embed.getImage().isEmpty()) {
            embedBuilder.image((String)discordString.apply(embed.getImage()));
        }
        if (embed.isTimestamp()) {
            embedBuilder.timestamp(Instant.now());
        }
        if (!(footer = embed.getFooter()).getText().isEmpty() || !footer.getIconUrl().isEmpty()) {
            embedBuilder.footer((String)discordString.apply(footer.getText()), (String)discordString.apply(footer.getIconUrl()));
        }
        return embedBuilder.build();
    }

    @Override
    public void hook() {
        ApplicationInfo applicationInfo;
        Integration.Discord.ChannelInfo channelInfo;
        String token = this.systemVariableResolver.substituteEnvVars(this.integration.getToken());
        if (token.isEmpty()) {
            return;
        }
        this.discordClient = DiscordClient.create((String)token);
        this.gateway = (GatewayDiscordClient)this.discordClient.gateway().login().block();
        if (this.gateway == null) {
            return;
        }
        Integration.Discord.Presence presence = this.integration.getPresence();
        if (presence.isEnable()) {
            Integration.Discord.Presence.Activity activity = presence.getActivity();
            ClientActivity clientActivity = activity.isEnable() ? ClientActivity.of((Activity.Type)Activity.Type.valueOf((String)activity.getType()), (String)activity.getName(), (String)activity.getUrl()) : null;
            this.gateway.updatePresence(ClientPresence.of((Status)Status.valueOf((String)presence.getStatus()), (ClientActivity)clientActivity)).block();
        }
        if ((channelInfo = this.integration.getChannelInfo()).isEnable() && channelInfo.getTicker().isEnable()) {
            long period = channelInfo.getTicker().getPeriod();
            this.taskScheduler.runAsyncTimer(this::updateChannelInfo, period, period);
            this.updateChannelInfo();
        }
        if (!this.integration.getMessageChannel().isEmpty()) {
            this.gateway.getEventDispatcher().on(this.messageCreateListener.getEventType()).flatMap(this.messageCreateListener::execute).subscribe();
        }
        if ((applicationInfo = (ApplicationInfo)this.gateway.getApplicationInfo().block()) == null) {
            return;
        }
        this.clientID = applicationInfo.getId().asLong();
        this.fLogger.info("Discord integration enabled");
    }

    @Override
    public void unhook() {
        if (this.gateway == null) {
            return;
        }
        this.gateway.logout().block();
        this.webhooks.clear();
        this.fLogger.info("Discord integration disabled");
    }

    public void updateChannelInfo() {
        if (this.gateway == null) {
            return;
        }
        if (!this.integration.getChannelInfo().isEnable()) {
            return;
        }
        Localization.Integration.Discord localization = this.fileResolver.getLocalization().getIntegration().getDiscord();
        for (Map.Entry<String, String> entry : localization.getInfoChannel().entrySet()) {
            String id = entry.getKey();
            if (!NumberUtils.isParsable((String)id)) continue;
            Snowflake snowflake = Snowflake.of((String)id);
            this.gateway.getChannelById(snowflake).blockOptional().ifPresent(channel -> {
                String name = PlainTextComponentSerializer.plainText().serialize(this.messagePipeline.builder((String)entry.getValue()).build());
                channel.getRestChannel().modify((ChannelModifyRequest)ChannelModifyRequest.builder().name(name).build(), null).block();
            });
        }
    }
}

