/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.discord;

import java.util.function.UnaryOperator;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.discord.DiscordIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class DiscordModule
extends AbstractModule {
    private final Integration.Discord integration;
    private final Permission.Integration.Discord permission;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;
    private final FLogger fLogger;

    @Inject
    public DiscordModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector, FLogger fLogger) {
        this.integration = fileResolver.getIntegration().getDiscord();
        this.permission = fileResolver.getPermission().getIntegration().getDiscord();
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
        this.fLogger = fLogger;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.reflectionResolver.hasClassOrElse("discord4j.core.DiscordClient", this::loadLibraries);
        this.addPredicate(fEntity -> {
            FPlayer fPlayer;
            return fEntity instanceof FPlayer && !(fPlayer = (FPlayer)fEntity).isSetting(FPlayer.Setting.DISCORD);
        });
        try {
            ((DiscordIntegration)this.injector.getInstance(DiscordIntegration.class)).hook();
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
    }

    @Override
    public void onDisable() {
        ((DiscordIntegration)this.injector.getInstance(DiscordIntegration.class)).unhook();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}discord4j").artifactId("discord4j-core").version("3.2.9").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("io{}netty").artifactId("netty-resolver-dns").version("5.0.0.Alpha2").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}discord4j").artifactId("discord4j-common").version("3.3.0-RC1").resolveTransitiveDependencies(true).build());
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> discordString) {
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        ((DiscordIntegration)this.injector.getInstance(DiscordIntegration.class)).sendMessage(sender, messageName, discordString);
    }
}

