/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.discord.listener;

import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.integration.discord.listener.EventListener;
import net.flectone.pulse.module.integration.discord.model.DiscordMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import reactor.core.publisher.Mono;

@Singleton
public class MessageCreateListener
extends EventListener<MessageCreateEvent> {
    private final Integration.Discord integration;

    @Inject
    public MessageCreateListener(FileResolver fileResolver) {
        this.integration = fileResolver.getIntegration().getDiscord();
    }

    @Override
    public Class<MessageCreateEvent> getEventType() {
        return MessageCreateEvent.class;
    }

    @Override
    public Mono<MessageCreateEvent> execute(MessageCreateEvent event) {
        Message discordMessage = event.getMessage();
        String channel = this.integration.getMessageChannel().get(MessageType.FROM_DISCORD_TO_MINECRAFT.name());
        if (channel == null) {
            return Mono.empty();
        }
        if (!channel.equals(discordMessage.getChannelId().asString())) {
            return Mono.empty();
        }
        String nickname = event.getMember().filter(member -> !member.isBot()).flatMap(User::getGlobalName).orElse(null);
        if (nickname == null) {
            return Mono.empty();
        }
        String message = discordMessage.getContent();
        if (message.isEmpty()) {
            if (discordMessage.getAttachments().isEmpty()) {
                return Mono.empty();
            }
            message = String.join((CharSequence)" ", discordMessage.getAttachments().stream().map(Attachment::getUrl).toList());
        }
        this.sendMessage(nickname, message);
        return Mono.empty();
    }

    @Async
    public void sendMessage(String nickname, String message) {
        this.sendMessage(((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)DiscordMetadata.builder().sender(FPlayer.UNKNOWN)).format(s -> Strings.CS.replace(s.getForMinecraft(), "<name>", nickname))).nickname(nickname)).range(Range.get(Range.Type.PROXY))).destination(this.integration.getDestination())).message(message)).sound(this.getModuleSound())).filter(fPlayer -> fPlayer.isSetting(FPlayer.Setting.DISCORD))).integration(string -> Strings.CS.replace(string, "<name>", nickname))).build());
    }

    @Override
    public void onEnable() {
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }
}

