/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.luckperms;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.util.logging.FLogger;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;

@Singleton
public class LuckPermsIntegration
implements FIntegration {
    private final FLogger fLogger;
    private LuckPerms luckPerms;

    @Inject
    public LuckPermsIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    @Override
    public void hook() {
        this.luckPerms = LuckPermsProvider.get();
        this.fLogger.info("\u2714 LuckPerms hooked");
    }

    @Async(delay=20L)
    public void hookLater() {
        this.hook();
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 LuckPerms unhooked");
    }

    public boolean hasPermission(FPlayer fPlayer, String permission) {
        User user = this.getUser(fPlayer);
        if (user == null) {
            return false;
        }
        return user.getCachedData().getPermissionData().checkPermission(permission).asBoolean();
    }

    public int getGroupWeight(FPlayer fPlayer) {
        User user = this.getUser(fPlayer);
        if (user == null) {
            return 0;
        }
        String groupName = user.getPrimaryGroup();
        Group group = this.luckPerms.getGroupManager().getGroup(groupName);
        if (group == null) {
            return 0;
        }
        return group.getWeight().orElse(0);
    }

    public String getPrefix(FPlayer fPlayer) {
        User user = this.getUser(fPlayer);
        if (user == null) {
            return null;
        }
        return user.getCachedData().getMetaData().getPrefix();
    }

    public String getSuffix(FPlayer fPlayer) {
        User user = this.getUser(fPlayer);
        if (user == null) {
            return null;
        }
        return user.getCachedData().getMetaData().getSuffix();
    }

    public Set<String> getGroups() {
        if (this.luckPerms == null) {
            return Collections.emptySet();
        }
        return this.luckPerms.getGroupManager().getLoadedGroups().stream().map(Group::getName).collect(Collectors.toSet());
    }

    private User getUser(FPlayer fPlayer) {
        if (this.luckPerms == null) {
            return null;
        }
        return this.luckPerms.getUserManager().getUser(fPlayer.getUuid());
    }
}

