/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.luckperms;

import java.util.Collections;
import java.util.Set;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.luckperms.LuckPermsIntegration;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.PlatformType;

@Singleton
public class LuckPermsModule
extends AbstractModule {
    private final Integration.Luckperms integration;
    private final Permission.Integration.Luckperms permission;
    private final LuckPermsIntegration luckPermsIntegration;
    private final PlatformServerAdapter platformServerAdapter;

    @Inject
    public LuckPermsModule(FileResolver fileResolver, LuckPermsIntegration luckPermsIntegration, PlatformServerAdapter platformServerAdapter) {
        this.integration = fileResolver.getIntegration().getLuckperms();
        this.permission = fileResolver.getPermission().getIntegration().getLuckperms();
        this.luckPermsIntegration = luckPermsIntegration;
        this.platformServerAdapter = platformServerAdapter;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        if (this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC) {
            this.luckPermsIntegration.hookLater();
        } else {
            this.luckPermsIntegration.hook();
        }
    }

    @Override
    public void onDisable() {
        this.luckPermsIntegration.unhook();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }

    public boolean hasLuckPermission(FPlayer fPlayer, String permission) {
        if (!this.isEnable()) {
            return false;
        }
        return this.luckPermsIntegration.hasPermission(fPlayer, permission);
    }

    public int getGroupWeight(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return 0;
        }
        if (!this.integration.isTabSort()) {
            return 0;
        }
        return this.luckPermsIntegration.getGroupWeight(fPlayer);
    }

    public String getPrefix(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.luckPermsIntegration.getPrefix(fPlayer);
    }

    public String getSuffix(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.luckPermsIntegration.getSuffix(fPlayer);
    }

    public Set<String> getGroups() {
        if (!this.isEnable()) {
            return Collections.emptySet();
        }
        return this.luckPermsIntegration.getGroups();
    }
}

