/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.miniplaceholders;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.miniplaceholders.MiniPlaceholdersIntegration;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class MiniPlaceholdersModule
extends AbstractModule {
    private final Integration.MiniPlaceholders integration;
    private final Permission.Integration.MiniPlaceholders permission;
    private final MiniPlaceholdersIntegration miniPlaceholdersIntegration;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public MiniPlaceholdersModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, MiniPlaceholdersIntegration miniPlaceholdersIntegration) {
        this.integration = fileResolver.getIntegration().getMiniplaceholders();
        this.permission = fileResolver.getPermission().getIntegration().getMiniplaceholders();
        this.listenerRegistry = listenerRegistry;
        this.miniPlaceholdersIntegration = miniPlaceholdersIntegration;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.registerPermission(this.permission.getUse());
        this.miniPlaceholdersIntegration.hookLater();
        this.listenerRegistry.register(MessageFormattingEvent.class, Event.Priority.HIGH, event -> {
            MessageFormattingEvent messageFormattingEvent = (MessageFormattingEvent)event;
            MessageContext messageContext = messageFormattingEvent.getContext();
            FEntity sender = messageContext.getSender();
            if (this.isModuleDisabledFor(sender)) {
                return;
            }
            this.miniPlaceholdersIntegration.onMessageFormattingEvent(messageFormattingEvent);
        });
    }

    @Override
    public void onDisable() {
        this.miniPlaceholdersIntegration.unhook();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }
}

