/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.placeholderapi;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Arrays;
import java.util.HashMap;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.placeholderapi.PlaceholderAPIModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.mapper.FPlayerMapper;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.logging.FLogger;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

@Singleton
public class PlaceholderAPIIntegration
implements FIntegration,
PulseListener {
    private final Message.Format.FColor fColorMessage;
    private final Permission.Integration.Placeholderapi permission;
    private final FPlayerService fPlayerService;
    private final FPlayerMapper fPlayerMapper;
    private final PlatformServerAdapter platformServerAdapter;
    private final Provider<PlaceholderAPIModule> placeholderAPIModuleProvider;
    private final FLogger fLogger;
    private final PermissionChecker permissionChecker;

    @Inject
    public PlaceholderAPIIntegration(FileResolver fileResolver, FPlayerService fPlayerService, FPlayerMapper fPlayerMapper, PlatformServerAdapter platformServerAdapter, Provider<PlaceholderAPIModule> placeholderAPIModuleProvider, FLogger fLogger, PermissionChecker permissionChecker) {
        this.fColorMessage = fileResolver.getMessage().getFormat().getFcolor();
        this.permission = fileResolver.getPermission().getIntegration().getPlaceholderapi();
        this.fPlayerService = fPlayerService;
        this.fPlayerMapper = fPlayerMapper;
        this.platformServerAdapter = platformServerAdapter;
        this.placeholderAPIModuleProvider = placeholderAPIModuleProvider;
        this.fLogger = fLogger;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public void hook() {
        this.register();
    }

    @Override
    public void unhook() {
        Placeholders.remove((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"fcolor"));
        Arrays.stream(FPlayer.Setting.values()).forEach(setting -> Placeholders.remove((class_2960)class_2960.method_60655((String)"flectonepulse", (String)setting.name().toLowerCase())));
        Placeholders.remove((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"player"));
        Placeholders.remove((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"ip"));
        Placeholders.remove((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"ping"));
        Placeholders.remove((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"online"));
        Placeholders.remove((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"tps"));
        this.fLogger.info("\u2716 Text Placeholder API unhooked");
    }

    @Async(delay=20L)
    public void register() {
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"fcolor"), (context, argument) -> this.fColorPlaceholder(context, argument, FColor.Type.SEE, FColor.Type.OUT));
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"fcolor_out"), (context, argument) -> this.fColorPlaceholder(context, argument, FColor.Type.OUT));
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"fcolor_see"), (context, argument) -> this.fColorPlaceholder(context, argument, FColor.Type.SEE));
        Arrays.stream(FPlayer.Setting.values()).forEach(setting -> Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)setting.name().toLowerCase()), (context, argument) -> {
            FPlayer fPlayer = this.fPlayerMapper.map(context.source());
            String value = fPlayer.getSettingValue((FPlayer.Setting)((Object)setting));
            if (setting == FPlayer.Setting.CHAT && value == null) {
                return PlaceholderResult.value((String)"default");
            }
            if (setting == FPlayer.Setting.STREAM_PREFIX && value != null && value.isBlank()) {
                return PlaceholderResult.value((String)"");
            }
            if (value == null) {
                return PlaceholderResult.value((String)"");
            }
            return value.isEmpty() ? PlaceholderResult.value((String)"true") : PlaceholderResult.value((String)value);
        }));
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"player"), (context, argument) -> {
            FPlayer fPlayer = this.fPlayerMapper.map(context.source());
            return PlaceholderResult.value((String)fPlayer.getName());
        });
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"ip"), (context, argument) -> {
            FPlayer fPlayer = this.fPlayerMapper.map(context.source());
            return PlaceholderResult.value((String)fPlayer.getIp());
        });
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"ping"), (context, argument) -> {
            FPlayer fPlayer = this.fPlayerMapper.map(context.source());
            return PlaceholderResult.value((String)String.valueOf(this.fPlayerService.getPing(fPlayer)));
        });
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"online"), (context, argument) -> PlaceholderResult.value((String)String.valueOf(this.platformServerAdapter.getOnlinePlayerCount())));
        Placeholders.register((class_2960)class_2960.method_60655((String)"flectonepulse", (String)"tps"), (context, argument) -> PlaceholderResult.value((String)this.platformServerAdapter.getTPS()));
        this.fLogger.info("\u2714 Text Placeholder API hooked");
    }

    @Pulse(priority=Event.Priority.LOW)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        FEntity sender = messageContext.getSender();
        if (((PlaceholderAPIModule)this.placeholderAPIModuleProvider.get()).isModuleDisabledFor(sender)) {
            return;
        }
        boolean isUserMessage = messageContext.isFlag(MessageFlag.USER_MESSAGE);
        if (!this.permissionChecker.check(sender, this.permission.getUse()) && isUserMessage) {
            return;
        }
        if (!(sender instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        Object player = this.fPlayerService.toPlatformFPlayer(fPlayer);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 playerEntity = (class_3222)player;
        String message = messageContext.getMessage();
        class_2561 text = Placeholders.parseText((class_2561)class_2561.method_43470((String)message), (PlaceholderContext)PlaceholderContext.of((class_2168)playerEntity.method_64396()));
        messageContext.setMessage(text.getString());
    }

    private PlaceholderResult fColorPlaceholder(PlaceholderContext context, String argument, FColor.Type ... types) {
        if (argument == null) {
            return PlaceholderResult.invalid();
        }
        if (!StringUtils.isNumeric((CharSequence)argument)) {
            return PlaceholderResult.invalid();
        }
        FPlayer fPlayer = this.fPlayerMapper.map(context.source());
        HashMap<Integer, String> colorsMap = new HashMap<Integer, String>(this.fColorMessage.getDefaultColors());
        for (FColor.Type type : types) {
            colorsMap.putAll(fPlayer.getFColors(type));
        }
        int colorNumber = Integer.parseInt(argument);
        return PlaceholderResult.value((String)((String)colorsMap.get(colorNumber)));
    }
}

