/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.placeholderapi;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.placeholderapi.PlaceholderAPIIntegration;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class PlaceholderAPIModule
extends AbstractModule {
    private final Integration.Placeholderapi integration;
    private final Permission.Integration.Placeholderapi permission;
    private final PlaceholderAPIIntegration placeholderAPIIntegration;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public PlaceholderAPIModule(FileResolver fileResolver, PlaceholderAPIIntegration placeholderAPIIntegration, ListenerRegistry listenerRegistry) {
        this.integration = fileResolver.getIntegration().getPlaceholderapi();
        this.permission = fileResolver.getPermission().getIntegration().getPlaceholderapi();
        this.placeholderAPIIntegration = placeholderAPIIntegration;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.registerPermission(this.permission.getUse());
        this.placeholderAPIIntegration.hook();
        this.listenerRegistry.register(PlaceholderAPIIntegration.class);
    }

    @Override
    public void onDisable() {
        this.placeholderAPIIntegration.unhook();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }
}

