/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.simplevoice;

import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.EntitySoundPacketEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.simplevoice.SimpleVoiceModule;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.sender.MessageSender;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.MuteChecker;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class SimpleVoiceIntegration
implements FIntegration,
VoicechatPlugin {
    private final FPlayerService fPlayerService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final MuteChecker muteChecker;
    private final MessageSender messageSender;
    private final MessagePipeline messagePipeline;
    private final FLogger fLogger;
    private boolean enable;

    public SimpleVoiceIntegration() {
        this.fPlayerService = null;
        this.moderationMessageFormatter = null;
        this.muteChecker = null;
        this.messageSender = null;
        this.messagePipeline = null;
        this.fLogger = null;
    }

    @Inject
    public SimpleVoiceIntegration(FPlayerService fPlayerService, ModerationMessageFormatter moderationMessageFormatter, MuteChecker muteChecker, MessageSender messageSender, MessagePipeline messagePipeline, FLogger fLogger) {
        this.fPlayerService = fPlayerService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.muteChecker = muteChecker;
        this.messageSender = messageSender;
        this.messagePipeline = messagePipeline;
        this.fLogger = fLogger;
    }

    public String getPluginId() {
        return "FlectonePulse";
    }

    public void registerEvents(EventRegistration registration) {
        SimpleVoiceIntegration simpleVoiceIntegration = SimpleVoiceModule.getSimpleVoiceIntegration();
        if (simpleVoiceIntegration == null) {
            return;
        }
        registration.registerEvent(MicrophonePacketEvent.class, simpleVoiceIntegration::onMicrophonePacketEvent);
        registration.registerEvent(EntitySoundPacketEvent.class, simpleVoiceIntegration::onEntitySoundPacketEvent);
    }

    @Override
    public void hook() {
        this.enable = true;
        this.fLogger.info("\u2714 SimpleVoice hooked");
    }

    @Override
    public void unhook() {
        this.enable = false;
        this.fLogger.info("\u2716 SimpleVoice unhooked");
    }

    public void onEntitySoundPacketEvent(EntitySoundPacketEvent event) {
        if (!this.enable) {
            return;
        }
        if (event.getSenderConnection() == null) {
            return;
        }
        if (event.getReceiverConnection() == null) {
            return;
        }
        ServerPlayer sender = event.getSenderConnection().getPlayer();
        FPlayer fSender = this.fPlayerService.getFPlayer(sender.getUuid());
        ServerPlayer receiver = event.getReceiverConnection().getPlayer();
        FPlayer fReceiver = this.fPlayerService.getFPlayer(receiver.getUuid());
        if (!fReceiver.isIgnored(fSender)) {
            return;
        }
        event.cancel();
    }

    public void onMicrophonePacketEvent(MicrophonePacketEvent event) {
        if (!this.enable) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getSenderConnection() == null) {
            return;
        }
        ServerPlayer player = event.getSenderConnection().getPlayer();
        FPlayer fPlayer = this.fPlayerService.getFPlayer(player.getUuid());
        MuteChecker.Status status = this.muteChecker.check(fPlayer);
        if (status == MuteChecker.Status.NONE) {
            return;
        }
        event.cancel();
        String message = this.moderationMessageFormatter.buildMuteMessage(fPlayer, status);
        this.messageSender.sendActionBar(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }
}

