/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.skinsrestorer;

import java.util.Optional;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.util.logging.FLogger;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.storage.PlayerStorage;

@Singleton
public class SkinsRestorerIntegration
implements FIntegration {
    private final FLogger fLogger;
    private SkinsRestorer skinsRestorer;

    @Inject
    public SkinsRestorerIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    @Override
    public void hook() {
        try {
            this.skinsRestorer = SkinsRestorerProvider.get();
            this.fLogger.info("\u2714 SkinsRestorer hooked");
        }
        catch (IllegalStateException e) {
            this.fLogger.warning("SkinsRestorer hook is failed, check https://skinsrestorer.net/docs/installation");
        }
    }

    @Async(delay=20L)
    public void hookLater() {
        this.hook();
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 SkinsRestorer unhooked");
    }

    public String getTextureUrl(FPlayer fPlayer) {
        if (this.skinsRestorer == null) {
            return null;
        }
        PlayerStorage storage = this.skinsRestorer.getPlayerStorage();
        try {
            Optional skin = storage.getSkinForPlayer(fPlayer.getUuid(), fPlayer.getName());
            return skin.map(PropertyUtils::getSkinTextureHash).orElse(null);
        }
        catch (DataRequestException e) {
            return null;
        }
    }
}

