/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.skinsrestorer;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.skinsrestorer.SkinsRestorerIntegration;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.PlatformType;

@Singleton
public class SkinsRestorerModule
extends AbstractModule {
    private final Integration.Skinsrestorer config;
    private final Permission.Integration.Skinsrestorer permission;
    private final SkinsRestorerIntegration skinsRestorerIntegration;
    private final PlatformServerAdapter platformServerAdapter;

    @Inject
    public SkinsRestorerModule(FileResolver fileResolver, SkinsRestorerIntegration skinsRestorerIntegration, PlatformServerAdapter platformServerAdapter) {
        this.config = fileResolver.getIntegration().getSkinsrestorer();
        this.permission = fileResolver.getPermission().getIntegration().getSkinsrestorer();
        this.skinsRestorerIntegration = skinsRestorerIntegration;
        this.platformServerAdapter = platformServerAdapter;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        if (this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC) {
            this.skinsRestorerIntegration.hookLater();
        } else {
            this.skinsRestorerIntegration.hook();
        }
    }

    @Override
    public void onDisable() {
        this.skinsRestorerIntegration.unhook();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.config.isEnable();
    }

    public String getTextureUrl(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.skinsRestorerIntegration.getTextureUrl(fPlayer);
    }
}

