/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.supervanish;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.supervanish.VanishIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class VanishModule
extends AbstractModule {
    private final Integration.Supervanish config;
    private final Permission.Integration.Supervanish permission;
    private final VanishIntegration vanishIntegration;

    @Inject
    public VanishModule(FileResolver fileResolver, VanishIntegration vanishIntegration) {
        this.config = fileResolver.getIntegration().getSupervanish();
        this.permission = fileResolver.getPermission().getIntegration().getSupervanish();
        this.vanishIntegration = vanishIntegration;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.vanishIntegration.hook();
    }

    @Override
    public void onDisable() {
        this.vanishIntegration.unhook();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.config.isEnable();
    }

    public boolean isVanished(FEntity sender) {
        if (this.isModuleDisabledFor(sender)) {
            return false;
        }
        return this.vanishIntegration.isVanished(sender);
    }
}

