/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.telegram;

import java.util.List;
import java.util.function.UnaryOperator;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.telegram.listener.MessageListener;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.util.logging.FLogger;
import org.telegram.telegrambots.client.okhttp.OkHttpTelegramClient;
import org.telegram.telegrambots.longpolling.TelegramBotsLongPollingApplication;
import org.telegram.telegrambots.longpolling.interfaces.LongPollingUpdateConsumer;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

@Singleton
public class TelegramIntegration
implements FIntegration {
    private final Integration.Telegram integration;
    private final FileResolver fileResolver;
    private final SystemVariableResolver systemVariableResolver;
    private final FLogger fLogger;
    private final MessageListener messageListener;
    private TelegramBotsLongPollingApplication botsApplication;
    private OkHttpTelegramClient telegramClient;

    @Inject
    public TelegramIntegration(FileResolver fileResolver, SystemVariableResolver systemVariableResolver, FLogger fLogger, MessageListener messageListener) {
        this.integration = fileResolver.getIntegration().getTelegram();
        this.fileResolver = fileResolver;
        this.systemVariableResolver = systemVariableResolver;
        this.fLogger = fLogger;
        this.messageListener = messageListener;
    }

    @Override
    public void hook() {
        String token = this.systemVariableResolver.substituteEnvVars(this.integration.getToken());
        if (token.isEmpty()) {
            return;
        }
        try {
            this.telegramClient = new OkHttpTelegramClient(token);
            this.botsApplication = new TelegramBotsLongPollingApplication();
            this.botsApplication.registerBot(token, (LongPollingUpdateConsumer)this.messageListener);
            this.fLogger.info("\u2714 Telegram integration enabled");
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> telegramString) {
        if (this.botsApplication == null) {
            return;
        }
        List<String> channels = this.integration.getMessageChannel().get(messageName);
        if (channels == null) {
            return;
        }
        if (channels.isEmpty()) {
            return;
        }
        Localization.Integration.Telegram localization = this.fileResolver.getLocalization().getIntegration().getTelegram();
        String message = localization.getMessageChannel().get(messageName);
        if (message == null) {
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        message = (String)telegramString.apply(message);
        for (String chat : channels) {
            SendMessage.SendMessageBuilder sendMessageBuilder = SendMessage.builder().chatId(chat).text(message);
            if (chat.contains("_")) {
                sendMessageBuilder.messageThreadId(Integer.valueOf(Integer.parseInt(chat.split("_")[1])));
            }
            this.executeMethod((BotApiMethod<?>)sendMessageBuilder.build());
        }
    }

    @Override
    public void unhook() {
        if (this.botsApplication == null) {
            return;
        }
        try {
            this.botsApplication.close();
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
        this.fLogger.info("\u2716 Telegram integration disabled");
    }

    public void executeMethod(BotApiMethod<?> method) {
        try {
            this.telegramClient.executeAsync(method);
        }
        catch (TelegramApiException e) {
            this.fLogger.warning(e);
        }
    }
}

