/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.telegram;

import java.util.function.UnaryOperator;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.telegram.TelegramIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;

@Singleton
public class TelegramModule
extends AbstractModule {
    private final Integration.Telegram integration;
    private final Permission.Integration.Telegram permission;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Inject
    public TelegramModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector) {
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
        this.integration = fileResolver.getIntegration().getTelegram();
        this.permission = fileResolver.getPermission().getIntegration().getTelegram();
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.reflectionResolver.hasClassOrElse("org.telegram.telegrambots.client.okhttp.OkHttpTelegramClient", this::loadLibraries);
        ((TelegramIntegration)this.injector.getInstance(TelegramIntegration.class)).hook();
        this.addPredicate(fEntity -> {
            FPlayer fPlayer;
            return fEntity instanceof FPlayer && !(fPlayer = (FPlayer)fEntity).isSetting(FPlayer.Setting.TELEGRAM);
        });
    }

    @Override
    public void onDisable() {
        ((TelegramIntegration)this.injector.getInstance(TelegramIntegration.class)).unhook();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("org{}telegram").artifactId("telegrambots-longpolling").version("9.0.0").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("org{}telegram").artifactId("telegrambots-client").version("9.0.0").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}squareup{}okhttp3").artifactId("okhttp").version("5.0.0-alpha.14").resolveTransitiveDependencies(true).build());
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> telegramString) {
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        ((TelegramIntegration)this.injector.getInstance(TelegramIntegration.class)).sendMessage(sender, messageName, telegramString);
    }
}

