/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.telegram.listener;

import java.util.List;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.integration.telegram.TelegramIntegration;
import net.flectone.pulse.module.integration.telegram.listener.EventListener;
import net.flectone.pulse.module.integration.telegram.model.TelegramMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.message.Message;

@Singleton
public class MessageListener
extends EventListener {
    private final Integration.Telegram integration;
    private final Provider<TelegramIntegration> telegramIntegration;

    @Inject
    public MessageListener(FileResolver fileResolver, Provider<TelegramIntegration> telegramIntegration) {
        this.integration = fileResolver.getIntegration().getTelegram();
        this.telegramIntegration = telegramIntegration;
    }

    @Override
    public void onEnable() {
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }

    public void consume(Update update) {
        if (!update.hasMessage()) {
            return;
        }
        Message message = update.getMessage();
        String text = message.getText();
        if (text == null) {
            return;
        }
        String author = message.getFrom().getUserName();
        if (author == null) {
            return;
        }
        String chat = message.getChat().getTitle();
        if (chat == null) {
            return;
        }
        Object chatID = String.valueOf(message.getChatId());
        if (message.isTopicMessage()) {
            chatID = (String)chatID + "_" + message.getMessageThreadId();
        }
        if (text.equalsIgnoreCase("/id")) {
            this.sendInfoMessage((String)chatID, message);
            return;
        }
        List<String> chats = this.integration.getMessageChannel().get(MessageType.FROM_TELEGRAM_TO_MINECRAFT.name());
        if (chats == null || !chats.contains(chatID)) {
            return;
        }
        this.sendMessage(author, chat, text);
    }

    @Async
    public void sendMessage(String author, String chat, String message) {
        this.sendMessage(((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)TelegramMetadata.builder().sender(FPlayer.UNKNOWN)).format(s -> StringUtils.replaceEach((String)s.getForMinecraft(), (String[])new String[]{"<name>", "<chat>"}, (String[])new String[]{String.valueOf(author), String.valueOf(chat)}))).author(author)).chat(chat)).message(message)).range(Range.get(Range.Type.PROXY))).destination(this.integration.getDestination())).sound(this.getModuleSound())).filter(fPlayer -> fPlayer.isSetting(FPlayer.Setting.TELEGRAM))).integration(string -> StringUtils.replaceEach((String)string, (String[])new String[]{"<name>", "<chat>"}, (String[])new String[]{author, chat}))).build());
    }

    private void sendInfoMessage(String chatID, Message message) {
        SendMessage.SendMessageBuilder sendMessage = SendMessage.builder().chatId(chatID).text("Channel id: " + chatID);
        if (message.isTopicMessage()) {
            sendMessage = sendMessage.messageThreadId(message.getMessageThreadId());
        }
        ((TelegramIntegration)this.telegramIntegration.get()).executeMethod((BotApiMethod<?>)sendMessage.build());
    }
}

