/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.twitch;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.TwitchClient;
import com.github.twitch4j.TwitchClientBuilder;
import com.github.twitch4j.events.ChannelGoLiveEvent;
import feign.Logger;
import java.util.List;
import java.util.function.UnaryOperator;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.twitch.listener.ChannelMessageListener;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class TwitchIntegration
implements FIntegration {
    private final Integration.Twitch integration;
    private final Localization.Integration.Twitch localization;
    private final ChannelMessageListener channelMessageListener;
    private final PlatformServerAdapter platformServerAdapter;
    private final SystemVariableResolver systemVariableResolver;
    private final FLogger fLogger;
    private OAuth2Credential oAuth2Credential;
    private TwitchClient twitchClient;

    @Inject
    public TwitchIntegration(FileResolver fileResolver, PlatformServerAdapter platformServerAdapter, SystemVariableResolver systemVariableResolver, ChannelMessageListener channelMessageListener, FLogger fLogger) {
        this.integration = fileResolver.getIntegration().getTwitch();
        this.localization = fileResolver.getLocalization().getIntegration().getTwitch();
        this.channelMessageListener = channelMessageListener;
        this.platformServerAdapter = platformServerAdapter;
        this.systemVariableResolver = systemVariableResolver;
        this.fLogger = fLogger;
    }

    @Override
    public void hook() {
        String token = this.systemVariableResolver.substituteEnvVars(this.integration.getToken());
        String identityProvider = this.systemVariableResolver.substituteEnvVars(this.integration.getClientID());
        if (token.isEmpty() || identityProvider.isEmpty()) {
            return;
        }
        this.oAuth2Credential = new OAuth2Credential(identityProvider, token);
        this.twitchClient = TwitchClientBuilder.builder().withEnableChat(Boolean.valueOf(true)).withEnableEventSocket(Boolean.valueOf(true)).withEnableHelix(Boolean.valueOf(true)).withFeignLogLevel(Logger.Level.NONE).withDefaultAuthToken(this.oAuth2Credential).withChatAccount(this.oAuth2Credential).build();
        for (List<String> channels : this.integration.getMessageChannel().values()) {
            for (String channel : channels) {
                if (this.twitchClient.getChat().isChannelJoined(channel)) continue;
                this.twitchClient.getChat().joinChannel(channel);
            }
        }
        if (!this.integration.getFollowChannel().isEmpty()) {
            this.fLogger.warning("Follow channel is currently not supported");
        }
        this.twitchClient.getEventManager().onEvent(ChannelGoLiveEvent.class, event -> {
            String channelName = event.getChannel().getName();
            List<String> commands = this.integration.getFollowChannel().get(channelName);
            if (commands == null) {
                return;
            }
            commands.forEach(this.platformServerAdapter::dispatchCommand);
        });
        if (!this.integration.getMessageChannel().isEmpty()) {
            this.twitchClient.getEventManager().onEvent(this.channelMessageListener.getEventType(), this.channelMessageListener::execute);
        }
        this.fLogger.info("\u2714 Twitch integration enabled");
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> twitchString) {
        List<String> channels = this.integration.getMessageChannel().get(messageName);
        if (channels == null) {
            return;
        }
        if (channels.isEmpty()) {
            return;
        }
        String message = this.localization.getMessageChannel().get(messageName);
        if (message == null) {
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        message = (String)twitchString.apply(message);
        for (String channel : channels) {
            this.twitchClient.getChat().sendMessage(channel, message);
        }
    }

    @Override
    public void unhook() {
        if (this.twitchClient == null) {
            return;
        }
        this.twitchClient.close();
        this.fLogger.info("\u2716 Twitch integration disabled");
    }
}

