/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.twitch.listener;

import com.github.twitch4j.chat.events.channel.ChannelMessageEvent;
import java.util.List;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.integration.twitch.listener.EventListener;
import net.flectone.pulse.module.integration.twitch.model.TwitchMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class ChannelMessageListener
extends EventListener<ChannelMessageEvent> {
    private final Integration.Twitch integration;

    @Inject
    public ChannelMessageListener(FileResolver fileResolver) {
        this.integration = fileResolver.getIntegration().getTwitch();
    }

    @Override
    public Class<ChannelMessageEvent> getEventType() {
        return ChannelMessageEvent.class;
    }

    @Override
    public void execute(ChannelMessageEvent event) {
        List<String> channel = this.integration.getMessageChannel().get(MessageType.FROM_TWITCH_TO_MINECRAFT.name());
        if (channel == null || channel.isEmpty()) {
            return;
        }
        String channelName = event.getChannel().getName();
        if (!channel.contains(channelName)) {
            return;
        }
        String nickname = event.getUser().getName();
        String message = event.getMessage();
        this.sendMessage(nickname, channelName, message);
    }

    @Async
    public void sendMessage(String nickname, String channel, String message) {
        this.sendMessage(((TwitchMetadata.TwitchMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)((TwitchMetadata.TwitchMetadataBuilder)TwitchMetadata.builder().sender(FPlayer.UNKNOWN)).format(s -> StringUtils.replaceEach((String)s.getForMinecraft(), (String[])new String[]{"<name>", "<channel>"}, (String[])new String[]{String.valueOf(nickname), String.valueOf(channel)}))).nickname(nickname)).channel(channel)).message(message)).range(Range.get(Range.Type.PROXY))).destination(this.integration.getDestination())).sound(this.getModuleSound())).filter(fPlayer -> fPlayer.isSetting(FPlayer.Setting.TWITCH))).integration(string -> StringUtils.replaceEach((String)string, (String[])new String[]{"<name>", "<channel>"}, (String[])new String[]{nickname, channel}))).build());
    }

    @Override
    public void onEnable() {
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }
}

