/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.yandex;

import java.time.Duration;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.logging.FLogger;
import yandex.cloud.api.ai.translate.v2.TranslationServiceGrpc;
import yandex.cloud.api.ai.translate.v2.TranslationServiceOuterClass;
import yandex.cloud.sdk.ServiceFactory;
import yandex.cloud.sdk.auth.Auth;
import yandex.cloud.sdk.auth.provider.CredentialProvider;

@Singleton
public class YandexIntegration
implements FIntegration {
    private final Integration.Yandex integration;
    private final FLogger fLogger;
    private ServiceFactory factory;

    @Inject
    public YandexIntegration(FileResolver fileResolver, FLogger fLogger) {
        this.integration = fileResolver.getIntegration().getYandex();
        this.fLogger = fLogger;
    }

    public String translate(String source, String target, String text) {
        TranslationServiceGrpc.TranslationServiceBlockingStub translationService = (TranslationServiceGrpc.TranslationServiceBlockingStub)this.factory.create(TranslationServiceGrpc.TranslationServiceBlockingStub.class, TranslationServiceGrpc::newBlockingStub);
        TranslationServiceOuterClass.TranslateResponse response = translationService.translate(TranslationServiceOuterClass.TranslateRequest.newBuilder().setSourceLanguageCode(source).setTargetLanguageCode(target).setFormat(TranslationServiceOuterClass.TranslateRequest.Format.PLAIN_TEXT).addTexts(text).setFolderId(this.integration.getFolderId()).build());
        return response.getTranslations(0).getText();
    }

    @Override
    public void hook() {
        try {
            this.factory = ServiceFactory.builder().credentialProvider((CredentialProvider.Builder)Auth.oauthTokenBuilder().oauth(this.integration.getToken())).requestTimeout(Duration.ofMinutes(1L)).build();
            this.fLogger.info("\u2714 Yandex integration enabled");
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 Yandex integration disabled");
    }
}

