/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.yandex;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.yandex.YandexIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;

@Singleton
public class YandexModule
extends AbstractModule {
    private final Integration.Yandex integration;
    private final Permission.Integration.Yandex permission;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Inject
    public YandexModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector) {
        this.integration = fileResolver.getIntegration().getYandex();
        this.permission = fileResolver.getPermission().getIntegration().getYandex();
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.reflectionResolver.hasClassOrElse("yandex.cloud.sdk.auth.Auth", this::loadLibraries);
        ((YandexIntegration)this.injector.getInstance(YandexIntegration.class)).hook();
    }

    @Override
    public void onDisable() {
        ((YandexIntegration)this.injector.getInstance(YandexIntegration.class)).unhook();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}yandex{}cloud").artifactId("java-sdk-services").version("2.8.0").resolveTransitiveDependencies(true).build());
    }

    @Override
    protected boolean isConfigEnable() {
        return this.integration.isEnable();
    }

    public String translate(FPlayer sender, String source, String target, String text) {
        if (this.isModuleDisabledFor(sender)) {
            return text;
        }
        return ((YandexIntegration)this.injector.getInstance(YandexIntegration.class)).translate(source, target, text);
    }
}

