/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.advancement;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.advancement.listener.AdvancementPulseListener;
import net.flectone.pulse.module.message.advancement.model.AdvancementMetadata;
import net.flectone.pulse.module.message.advancement.model.ChatAdvancement;
import net.flectone.pulse.module.message.advancement.model.CommandAdvancement;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

@Singleton
public class AdvancementModule
extends AbstractModuleLocalization<Localization.Message.Advancement> {
    private final Message.Advancement message;
    private final Permission.Message.Advancement permission;
    private final FPlayerService fPlayerService;
    private final IntegrationModule integrationModule;
    private final MessagePipeline messagePipeline;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public AdvancementModule(FileResolver fileResolver, FPlayerService fPlayerService, IntegrationModule integrationModule, MessagePipeline messagePipeline, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getAdvancement(), MessageType.ADVANCEMENT);
        this.message = fileResolver.getMessage().getAdvancement();
        this.permission = fileResolver.getPermission().getMessage().getAdvancement();
        this.fPlayerService = fPlayerService;
        this.integrationModule = integrationModule;
        this.messagePipeline = messagePipeline;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(AdvancementPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fReceiver, ChatAdvancement chatAdvancement) {
        FPlayer fTarget = this.fPlayerService.getFPlayer(chatAdvancement.owner());
        if (fTarget.isUnknown()) {
            return;
        }
        if (this.isModuleDisabledFor(fTarget)) {
            return;
        }
        if (!fTarget.equals(fReceiver)) {
            return;
        }
        this.sendMessage(((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((EventMetadata.EventMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)AdvancementMetadata.builder().sender(fTarget)).format(s -> this.convert((Localization.Message.Advancement)s, chatAdvancement))).advancement(chatAdvancement)).range(this.message.getRange())).destination(this.message.getDestination())).sound(this.getModuleSound())).filter(fPlayer -> fPlayer.isSetting(FPlayer.Setting.ADVANCEMENT) && this.integrationModule.canSeeVanished(fTarget, (FEntity)fPlayer))).tagResolvers(fResolver -> new TagResolver[]{this.advancementTag(fTarget, (FPlayer)fResolver, chatAdvancement)})).proxy(dataOutputStream -> dataOutputStream.writeAsJson(chatAdvancement))).integration()).build());
    }

    @Async
    public void send(boolean revoke, FPlayer fPlayer, CommandAdvancement commandAdvancement) {
        if (commandAdvancement.isIncorrect()) {
            return;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(commandAdvancement.owner());
        if (fTarget.isUnknown()) {
            return;
        }
        AdvancementMetadata.AdvancementMetadataBuilder metadataBuilder = (AdvancementMetadata.AdvancementMetadataBuilder)((EventMetadata.EventMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)((AdvancementMetadata.AdvancementMetadataBuilder)AdvancementMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(s -> {
            Localization.Message.Advancement.Command subcommand = revoke ? s.getRevoke() : s.getGrant();
            return switch (commandAdvancement.relation().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Strings.CS.replace(subcommand.getManyToOne(), "<number>", String.valueOf(commandAdvancement.content()));
                case 2 -> Strings.CS.replace(subcommand.getOneToOne(), "<advancement>", this.stripSingleQuotes(commandAdvancement.content()));
                case 1 -> subcommand.getOneToOne();
            };
        })).advancement(commandAdvancement)).sound(this.getModuleSound());
        if (commandAdvancement.relation() == Relation.ONE_TO_ONE_ADVANCEMENT && commandAdvancement.chatAdvancement() != null) {
            metadataBuilder = (AdvancementMetadata.AdvancementMetadataBuilder)metadataBuilder.tagResolvers(fResolver -> new TagResolver[]{this.advancementTag(fTarget, fPlayer, commandAdvancement.chatAdvancement())});
        }
        this.sendMessage(metadataBuilder.build());
    }

    public String convert(Localization.Message.Advancement message, ChatAdvancement chatAdvancement) {
        String string = switch (chatAdvancement.type()) {
            case MinecraftTranslationKey.CHAT_TYPE_ACHIEVEMENT_TAKEN -> message.getTaken().getFormat();
            case MinecraftTranslationKey.CHAT_TYPE_ADVANCEMENT_GOAL -> message.getGoal().getFormat();
            case MinecraftTranslationKey.CHAT_TYPE_ADVANCEMENT_CHALLENGE -> message.getChallenge().getFormat();
            default -> message.getTask().getFormat();
        };
        return StringUtils.replaceEach((String)string, (String[])new String[]{"<title>", "<description>"}, (String[])new String[]{this.stripSingleQuotes(chatAdvancement.title()), this.stripSingleQuotes(chatAdvancement.description())});
    }

    public TagResolver advancementTag(FEntity sender, FPlayer receiver, @NotNull ChatAdvancement chatAdvancement) {
        String tag = "advancement";
        if (!this.isEnable()) {
            return MessagePipeline.ReplacementTag.empty(tag);
        }
        return TagResolver.resolver((String)tag, (argumentQueue, context) -> {
            Localization.Message.Advancement localization = (Localization.Message.Advancement)this.resolveLocalization(receiver);
            String title = switch (chatAdvancement.type()) {
                case MinecraftTranslationKey.CHAT_TYPE_ACHIEVEMENT_TAKEN -> localization.getTaken().getTag();
                case MinecraftTranslationKey.CHAT_TYPE_ADVANCEMENT_GOAL -> localization.getGoal().getTag();
                case MinecraftTranslationKey.CHAT_TYPE_ADVANCEMENT_CHALLENGE -> localization.getChallenge().getTag();
                default -> localization.getTask().getTag();
            };
            title = StringUtils.replaceEach((String)title, (String[])new String[]{"<title>", "<description>"}, (String[])new String[]{this.stripSingleQuotes(chatAdvancement.title()), this.stripSingleQuotes(chatAdvancement.description())});
            Component component = this.messagePipeline.builder(sender, receiver, title).build();
            return Tag.inserting((Component)component);
        });
    }

    private String stripSingleQuotes(String string) {
        return Strings.CS.replace(string, "'", "");
    }

    public static enum Relation {
        MANY_TO_ONE,
        ONE_TO_ONE_ADVANCEMENT,
        ONE_TO_ONE_TEXT;

    }
}

