/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.advancement.extractor;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.advancement.AdvancementModule;
import net.flectone.pulse.module.message.advancement.model.ChatAdvancement;
import net.flectone.pulse.module.message.advancement.model.CommandAdvancement;
import net.flectone.pulse.processing.extractor.Extractor;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.incendo.cloud.type.tuple.Pair;
import org.incendo.cloud.type.tuple.Triplet;

@Singleton
public class AdvancementExtractor
extends Extractor {
    @Inject
    public AdvancementExtractor() {
    }

    public Optional<ChatAdvancement> extractFromChat(MessageReceiveEvent event) {
        Pair<String, String> pair;
        Component achievementComp;
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        List<Component> translationArguments = translatableComponent.args();
        if (translationArguments.size() < 2) {
            return Optional.empty();
        }
        Component component = translationArguments.get(0);
        if (!(component instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent targetComponent = (TextComponent)component;
        String target = this.extractTarget(targetComponent);
        Component component2 = achievementComp = translationArguments.get(1);
        Objects.requireNonNull(component2);
        Component component3 = component2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslatableComponent.class, TextComponent.class}, (Object)component3, n)) {
                case 0: {
                    TranslatableComponent titleComponent = (TranslatableComponent)component3;
                    if (!titleComponent.key().equals("chat.square_brackets") || titleComponent.args().isEmpty()) {
                        n = 1;
                        continue block4;
                    }
                    pair = this.extractChatAdvancementComponent(titleComponent.args().get(0));
                    break block4;
                }
                case 1: {
                    TextComponent textComp = (TextComponent)component3;
                    if (!textComp.content().equals("[") || textComp.children().isEmpty()) {
                        n = 2;
                        continue block4;
                    }
                    pair = this.extractChatAdvancementComponent(textComp.children().get(0));
                    break block4;
                }
                default: {
                    pair = null;
                    break block4;
                }
            }
            break;
        }
        Pair<String, String> pair2 = pair;
        if (pair2 == null) {
            return Optional.empty();
        }
        String title = (String)pair2.first();
        String description = (String)pair2.second();
        if (description.isBlank() && title.contains(".title")) {
            description = Strings.CS.replace(title, ".title", ".description");
        }
        ChatAdvancement chatAdvancement = new ChatAdvancement(target, title, description, event.getTranslationKey());
        return Optional.of(chatAdvancement);
    }

    public Optional<CommandAdvancement> extractFromCommand(MessageReceiveEvent event) {
        AdvancementModule.Relation relation;
        Component argument;
        Component playerArgument;
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (translatableComponent.args().size() < 2) {
            return Optional.empty();
        }
        MinecraftTranslationKey type = event.getTranslationKey();
        if (type == MinecraftTranslationKey.COMMANDS_ACHIEVEMENT_GIVE_ONE || type == MinecraftTranslationKey.COMMANDS_ADVANCEMENT_GRANT_EVERYTHING_SUCCESS || type == MinecraftTranslationKey.COMMANDS_ADVANCEMENT_REVOKE_EVERYTHING_SUCCESS) {
            playerArgument = translatableComponent.args().get(0);
            argument = translatableComponent.args().get(1);
        } else {
            argument = translatableComponent.args().get(0);
            playerArgument = translatableComponent.args().get(1);
        }
        if (!(playerArgument instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent playerComponent = (TextComponent)playerArgument;
        String target = this.extractTarget(playerComponent);
        String content = null;
        ChatAdvancement chatAdvancement = null;
        switch (type) {
            case COMMANDS_ADVANCEMENT_REVOKE_ONE_TO_ONE_SUCCESS: 
            case COMMANDS_ADVANCEMENT_GRANT_ONE_TO_ONE_SUCCESS: 
            case COMMANDS_ACHIEVEMENT_TAKE_ONE: 
            case COMMANDS_ACHIEVEMENT_GIVE_ONE: {
                MinecraftTranslationKey advancementType;
                String description;
                String title;
                Component component = argument;
                Objects.requireNonNull(component);
                Component component2 = component;
                int n = 0;
                block9: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslatableComponent.class, TextComponent.class, TextComponent.class}, (Object)component2, n)) {
                        case 0: {
                            TranslatableComponent argumentIn = (TranslatableComponent)component2;
                            if (!argumentIn.key().equals("chat.square_brackets") || argumentIn.args().isEmpty()) {
                                n = 1;
                                continue block9;
                            }
                            Triplet<String, String, MinecraftTranslationKey> triplet = this.extractCommandAdvancementComponent(argumentIn.args().get(0));
                            title = (String)triplet.first();
                            description = (String)triplet.second();
                            advancementType = (MinecraftTranslationKey)((Object)triplet.third());
                            break block9;
                        }
                        case 1: {
                            TextComponent textComponent = (TextComponent)component2;
                            if (!textComponent.content().equals("[") || textComponent.children().isEmpty()) {
                                n = 2;
                                continue block9;
                            }
                            Triplet<String, String, MinecraftTranslationKey> triplet = this.extractCommandAdvancementComponent(textComponent.children().get(0));
                            title = (String)triplet.first();
                            description = (String)triplet.second();
                            advancementType = (MinecraftTranslationKey)((Object)triplet.third());
                            break block9;
                        }
                        case 2: {
                            TextComponent textComponent = (TextComponent)component2;
                            content = textComponent.content();
                            AdvancementModule.Relation relation2 = AdvancementModule.Relation.ONE_TO_ONE_TEXT;
                            CommandAdvancement commandAdvancement = new CommandAdvancement(relation2, target, null, content);
                            return Optional.of(commandAdvancement);
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                    break;
                }
                chatAdvancement = new ChatAdvancement(target, title, description, advancementType);
                relation = AdvancementModule.Relation.ONE_TO_ONE_ADVANCEMENT;
                break;
            }
            case COMMANDS_ADVANCEMENT_REVOKE_MANY_TO_ONE_SUCCESS: 
            case COMMANDS_ADVANCEMENT_GRANT_MANY_TO_ONE_SUCCESS: 
            case COMMANDS_ACHIEVEMENT_TAKE_MANY: 
            case COMMANDS_ACHIEVEMENT_GIVE_MANY: 
            case COMMANDS_ADVANCEMENT_GRANT_EVERYTHING_SUCCESS: 
            case COMMANDS_ADVANCEMENT_REVOKE_EVERYTHING_SUCCESS: 
            case COMMANDS_ADVANCEMENT_REVOKE_ONLY_SUCCESS: 
            case COMMANDS_ADVANCEMENT_GRANT_ONLY_SUCCESS: {
                if (!(argument instanceof TextComponent)) {
                    return Optional.empty();
                }
                TextComponent textComponent = (TextComponent)argument;
                content = textComponent.content();
                relation = type == MinecraftTranslationKey.COMMANDS_ADVANCEMENT_REVOKE_ONLY_SUCCESS || type == MinecraftTranslationKey.COMMANDS_ADVANCEMENT_GRANT_ONLY_SUCCESS ? AdvancementModule.Relation.ONE_TO_ONE_TEXT : AdvancementModule.Relation.MANY_TO_ONE;
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        CommandAdvancement commandAdvancement = new CommandAdvancement(relation, target, chatAdvancement, content);
        return Optional.of(commandAdvancement);
    }

    private Pair<String, String> extractChatAdvancementComponent(Component component) {
        String title = "";
        String description = "";
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            title = textComponent.content();
        } else if (component instanceof TranslatableComponent) {
            Component hoverValue;
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            title = translatableComponent.key();
            HoverEvent<?> hoverEvent = translatableComponent.hoverEvent();
            if (hoverEvent != null && hoverEvent.action() == HoverEvent.Action.SHOW_TEXT && (hoverValue = (Component)hoverEvent.value()).children().size() > 1) {
                String string;
                Component descComponent = hoverValue.children().get(1);
                if (descComponent instanceof TranslatableComponent) {
                    TranslatableComponent descTranslatable = (TranslatableComponent)descComponent;
                    string = descTranslatable.key();
                } else if (descComponent instanceof TextComponent) {
                    TextComponent descText = (TextComponent)descComponent;
                    string = descText.content();
                } else {
                    string = "";
                }
                description = string;
            }
        }
        return Pair.of((Object)title, (Object)description);
    }

    private Triplet<String, String, MinecraftTranslationKey> extractCommandAdvancementComponent(Component component) {
        String title = "";
        String description = "";
        MinecraftTranslationKey advancementType = MinecraftTranslationKey.CHAT_TYPE_ADVANCEMENT_TASK;
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            title = textComponent.content();
        } else if (component instanceof TranslatableComponent) {
            TranslatableComponent titleComponent = (TranslatableComponent)component;
            title = titleComponent.key();
            HoverEvent<?> hoverEvent = titleComponent.hoverEvent();
            if (hoverEvent != null && hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
                Component hoverValue = (Component)hoverEvent.value();
                if (hoverValue.children().size() > 1) {
                    String string;
                    Component descComponent = hoverValue.children().get(1);
                    if (descComponent instanceof TranslatableComponent) {
                        TranslatableComponent descTranslatable = (TranslatableComponent)descComponent;
                        string = descTranslatable.key();
                    } else if (descComponent instanceof TextComponent) {
                        TextComponent descText = (TextComponent)descComponent;
                        string = descText.content();
                    } else {
                        string = "";
                    }
                    description = string;
                    advancementType = NamedTextColor.DARK_PURPLE.equals(hoverValue.color()) ? MinecraftTranslationKey.CHAT_TYPE_ADVANCEMENT_CHALLENGE : MinecraftTranslationKey.CHAT_TYPE_ADVANCEMENT_TASK;
                }
            } else {
                title = titleComponent.key();
                description = "";
            }
        }
        return Triplet.of((Object)title, (Object)description, (Object)((Object)advancementType));
    }
}

