/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.advancement.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.advancement.AdvancementModule;
import net.flectone.pulse.module.message.advancement.extractor.AdvancementExtractor;
import net.flectone.pulse.module.message.advancement.model.ChatAdvancement;
import net.flectone.pulse.module.message.advancement.model.CommandAdvancement;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class AdvancementPulseListener
implements PulseListener {
    private final Message.Advancement message;
    private final AdvancementModule advancementModule;
    private final AdvancementExtractor advancementExtractor;

    @Inject
    public AdvancementPulseListener(FileResolver fileResolver, AdvancementModule advancementModule, AdvancementExtractor advancementExtractor) {
        this.message = fileResolver.getMessage().getAdvancement();
        this.advancementModule = advancementModule;
        this.advancementExtractor = advancementExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        switch (event.getTranslationKey()) {
            case CHAT_TYPE_ADVANCEMENT_TASK: 
            case CHAT_TYPE_ADVANCEMENT_GOAL: 
            case CHAT_TYPE_ADVANCEMENT_CHALLENGE: 
            case CHAT_TYPE_ACHIEVEMENT: 
            case CHAT_TYPE_ACHIEVEMENT_TAKEN: {
                Optional<ChatAdvancement> advancement = this.advancementExtractor.extractFromChat(event);
                if (advancement.isEmpty()) {
                    return;
                }
                event.setCancelled(true);
                this.advancementModule.send(event.getFPlayer(), advancement.get());
                break;
            }
            case COMMANDS_ADVANCEMENT_GRANT_ONE_TO_ONE_SUCCESS: 
            case COMMANDS_ADVANCEMENT_GRANT_MANY_TO_ONE_SUCCESS: 
            case COMMANDS_ACHIEVEMENT_GIVE_ONE: 
            case COMMANDS_ACHIEVEMENT_GIVE_MANY: 
            case COMMANDS_ADVANCEMENT_GRANT_ONLY_SUCCESS: 
            case COMMANDS_ADVANCEMENT_GRANT_EVERYTHING_SUCCESS: {
                if (!this.message.isGrant()) {
                    return;
                }
                Optional<CommandAdvancement> commandAdvancement = this.advancementExtractor.extractFromCommand(event);
                if (commandAdvancement.isEmpty()) {
                    return;
                }
                event.setCancelled(true);
                this.advancementModule.send(false, event.getFPlayer(), commandAdvancement.get());
                break;
            }
            case COMMANDS_ADVANCEMENT_REVOKE_MANY_TO_ONE_SUCCESS: 
            case COMMANDS_ADVANCEMENT_REVOKE_ONE_TO_ONE_SUCCESS: 
            case COMMANDS_ACHIEVEMENT_TAKE_MANY: 
            case COMMANDS_ACHIEVEMENT_TAKE_ONE: 
            case COMMANDS_ADVANCEMENT_REVOKE_EVERYTHING_SUCCESS: 
            case COMMANDS_ADVANCEMENT_REVOKE_ONLY_SUCCESS: {
                if (!this.message.isRevoke()) {
                    return;
                }
                Optional<CommandAdvancement> commandAdvancement = this.advancementExtractor.extractFromCommand(event);
                if (commandAdvancement.isEmpty()) {
                    return;
                }
                event.setCancelled(true);
                this.advancementModule.send(true, event.getFPlayer(), commandAdvancement.get());
            }
        }
    }
}

