/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.afk;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.afk.listener.AfkPulseListener;
import net.flectone.pulse.module.message.afk.model.AFKMetadata;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.incendo.cloud.type.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Singleton
public class AfkModule
extends AbstractModuleLocalization<Localization.Message.Afk> {
    private final Map<UUID, Pair<Integer, PlatformPlayerAdapter.Coordinates>> playersCoordinates = new HashMap<UUID, Pair<Integer, PlatformPlayerAdapter.Coordinates>>();
    private final Message.Afk message;
    private final Permission.Message.Afk permission;
    private final FPlayerService fPlayerService;
    private final TaskScheduler taskScheduler;
    private final IntegrationModule integrationModule;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public AfkModule(FileResolver fileResolver, FPlayerService fPlayerService, TaskScheduler taskScheduler, IntegrationModule integrationModule, PlatformPlayerAdapter platformPlayerAdapter, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getAfk(), MessageType.AFK);
        this.message = fileResolver.getMessage().getAfk();
        this.permission = fileResolver.getPermission().getMessage().getAfk();
        this.fPlayerService = fPlayerService;
        this.taskScheduler = taskScheduler;
        this.integrationModule = integrationModule;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        if (this.message.getTicker().isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::check), this.message.getTicker().getPeriod());
        }
        this.listenerRegistry.register(AfkPulseListener.class);
    }

    @Override
    public void onDisable() {
        this.playersCoordinates.clear();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void addTag(MessageContext messageContext) {
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (!(sender instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.AFK_SUFFIX, (argumentQueue, context) -> {
            String afkSuffix = fPlayer.getSettingValue(FPlayer.Setting.AFK_SUFFIX);
            if (StringUtils.isEmpty((CharSequence)afkSuffix)) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            return Tag.preProcessParsed((String)afkSuffix);
        });
    }

    @Async
    public void remove(@NotNull String action, FPlayer fPlayer) {
        if (action.isEmpty()) {
            fPlayer.removeSetting(FPlayer.Setting.AFK_SUFFIX);
            this.playersCoordinates.remove(fPlayer.getUuid());
            this.fPlayerService.deleteSetting(fPlayer, FPlayer.Setting.AFK_SUFFIX);
            return;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.message.getIgnore().contains(action)) {
            return;
        }
        this.playersCoordinates.put(fPlayer.getUuid(), (Pair<Integer, PlatformPlayerAdapter.Coordinates>)Pair.of((Object)0, (Object)new PlatformPlayerAdapter.Coordinates(0.0, -1000.0, 0.0)));
        this.check(fPlayer);
    }

    private void check(@NotNull FPlayer fPlayer) {
        if (!fPlayer.isOnline()) {
            String afkSuffix = fPlayer.getSettingValue(FPlayer.Setting.AFK_SUFFIX);
            fPlayer.removeSetting(FPlayer.Setting.AFK_SUFFIX);
            this.playersCoordinates.remove(fPlayer.getUuid());
            if (afkSuffix != null) {
                this.send(fPlayer);
            }
            return;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        PlatformPlayerAdapter.Coordinates coordinates = this.platformPlayerAdapter.getCoordinates(fPlayer);
        if (coordinates == null) {
            return;
        }
        int time = (int)(System.currentTimeMillis() / 1000L);
        Pair<Integer, PlatformPlayerAdapter.Coordinates> timeVector = this.playersCoordinates.get(fPlayer.getUuid());
        if (timeVector == null || !((PlatformPlayerAdapter.Coordinates)timeVector.second()).equals(coordinates)) {
            if (fPlayer.isSetting(FPlayer.Setting.AFK_SUFFIX)) {
                fPlayer.removeSetting(FPlayer.Setting.AFK_SUFFIX);
                this.playersCoordinates.remove(fPlayer.getUuid());
                this.fPlayerService.deleteSetting(fPlayer, FPlayer.Setting.AFK_SUFFIX);
                this.send(fPlayer);
            }
            this.playersCoordinates.put(fPlayer.getUuid(), (Pair<Integer, PlatformPlayerAdapter.Coordinates>)Pair.of((Object)time, (Object)coordinates));
            return;
        }
        if (fPlayer.isSetting(FPlayer.Setting.AFK_SUFFIX)) {
            return;
        }
        if (time - (Integer)timeVector.first() < this.message.getDelay()) {
            return;
        }
        this.setAfk(fPlayer);
    }

    public void setAfk(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.fPlayerService.saveOrUpdateSetting(fPlayer, FPlayer.Setting.AFK_SUFFIX, ((Localization.Message.Afk)this.resolveLocalization()).getSuffix());
        this.send(fPlayer);
    }

    private void send(FPlayer fPlayer) {
        boolean isAfk;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Range range = this.message.getRange();
        boolean bl = isAfk = !fPlayer.isSetting(FPlayer.Setting.AFK_SUFFIX);
        if (range.is(Range.Type.PLAYER)) {
            if (!fPlayer.isSetting(FPlayer.Setting.AFK)) {
                return;
            }
            this.sendMessage(((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((EventMetadata.EventMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)AFKMetadata.builder().sender(fPlayer)).format(s -> isAfk ? s.getFormatFalse().getLocal() : s.getFormatTrue().getLocal())).newStatus(isAfk)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
            return;
        }
        this.sendMessage(((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((EventMetadata.EventMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)AFKMetadata.builder().sender(fPlayer)).format(s -> isAfk ? s.getFormatFalse().getGlobal() : s.getFormatTrue().getGlobal())).newStatus(isAfk)).range(range)).destination(this.message.getDestination())).sound(this.getModuleSound())).filter(fReceiver -> fReceiver.isSetting(FPlayer.Setting.AFK) && this.integrationModule.canSeeVanished(fPlayer, (FEntity)fReceiver))).proxy(dataOutputStream -> dataOutputStream.writeBoolean(isAfk))).integration()).build());
    }
}

