/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.auto;

import java.util.List;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class AutoModule
extends AbstractModuleListLocalization<Localization.Message.Auto> {
    private final Message.Auto message;
    private final Permission.Message.Auto permission;
    private final TaskScheduler taskScheduler;
    private final FPlayerService fPlayerService;

    @Inject
    public AutoModule(FileResolver fileResolver, TaskScheduler taskScheduler, FPlayerService fPlayerService) {
        super(localization -> localization.getMessage().getAuto(), MessageType.AUTO);
        this.message = fileResolver.getMessage().getAuto();
        this.permission = fileResolver.getPermission().getMessage().getAuto();
        this.taskScheduler = taskScheduler;
        this.fPlayerService = fPlayerService;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.message.getTypes().forEach((key, value) -> {
            Sound sound = this.createSound(value.getSound(), this.permission.getTypes().get(key));
            Ticker ticker = value.getTicker();
            if (ticker.isEnable()) {
                this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(fPlayer -> this.send((FPlayer)fPlayer, (String)key, (Message.Auto.Type)value, sound)), ticker.getPeriod());
            }
        });
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void send(FPlayer fPlayer, String name, Message.Auto.Type type, Sound sound) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!fPlayer.isSetting(FPlayer.Setting.AUTO)) {
            return;
        }
        List<String> messages = ((Localization.Message.Auto)this.resolveLocalization(fPlayer)).getTypes().get(name);
        if (messages == null) {
            return;
        }
        String format = this.getNextMessage(fPlayer, type.isRandom(), messages);
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(format)).destination(type.getDestination())).sound(sound)).filter(fReceiver -> fReceiver.isSetting(FPlayer.Setting.AUTO))).build());
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return List.of();
    }
}

