/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.bed;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.bed.listener.BedPulseListener;
import net.flectone.pulse.module.message.bed.model.BedMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class BedModule
extends AbstractModuleLocalization<Localization.Message.Bed> {
    private final Message.Bed message;
    private final Permission.Message.Bed permission;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public BedModule(FileResolver fileResolver, ListenerRegistry listenerRegistry) {
        super((Localization localization) -> localization.getMessage().getBed(), MessageType.BED);
        this.message = fileResolver.getMessage().getBed();
        this.permission = fileResolver.getPermission().getMessage().getBed();
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(BedPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, MinecraftTranslationKey minecraftTranslationKey) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.sendMessage(((BedMetadata.BedMetadataBuilder)((BedMetadata.BedMetadataBuilder)((EventMetadata.EventMetadataBuilder)((BedMetadata.BedMetadataBuilder)((BedMetadata.BedMetadataBuilder)((BedMetadata.BedMetadataBuilder)BedMetadata.builder().sender(fPlayer)).filterPlayer(fPlayer)).format(bed -> switch (minecraftTranslationKey) {
            case MinecraftTranslationKey.BLOCK_MINECRAFT_BED_NO_SLEEP, MinecraftTranslationKey.TILE_BED_NO_SLEEP -> bed.getNoSleep();
            case MinecraftTranslationKey.BLOCK_MINECRAFT_BED_NOT_SAFE, MinecraftTranslationKey.TILE_BED_NOT_SAFE -> bed.getNotSafe();
            case MinecraftTranslationKey.BLOCK_MINECRAFT_BED_OBSTRUCTED, MinecraftTranslationKey.BLOCK_MINECRAFT_SPAWN_NOT_VALID -> bed.getObstructed();
            case MinecraftTranslationKey.BLOCK_MINECRAFT_BED_OCCUPIED, MinecraftTranslationKey.TILE_BED_OCCUPIED -> bed.getOccupied();
            case MinecraftTranslationKey.BLOCK_MINECRAFT_BED_TOO_FAR_AWAY -> bed.getTooFarAway();
            default -> "";
        })).translationKey(minecraftTranslationKey)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

