/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.book;

import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

@Singleton
public class BookModule
extends AbstractModule {
    private final Message.Book message;
    private final Permission.Message.Book permission;
    private final MessagePipeline messagePipeline;

    @Inject
    public BookModule(FileResolver fileResolver, MessagePipeline messagePipeline) {
        this.message = fileResolver.getMessage().getBook();
        this.permission = fileResolver.getPermission().getMessage().getBook();
        this.messagePipeline = messagePipeline;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public String format(FPlayer fPlayer, String string) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        try {
            TextComponent deserialized = LegacyComponentSerializer.legacySection().deserialize(string);
            Component component = this.messagePipeline.builder(fPlayer, Strings.CS.replace(string, "\u00a7", "&")).flag(MessageFlag.USER_MESSAGE, true).build().mergeStyle(deserialized);
            return LegacyComponentSerializer.legacySection().serialize(component);
        }
        catch (ParsingException parsingException) {
            return string;
        }
    }
}

