/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.brand;

import java.util.List;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.module.message.brand.listener.BrandPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class BrandModule
extends AbstractModuleListLocalization<Localization.Message.Brand> {
    private final Message.Brand message;
    private final Permission.Message.Brand permission;
    private final FPlayerService fPlayerService;
    private final TaskScheduler taskScheduler;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public BrandModule(FileResolver fileResolver, FPlayerService fPlayerService, TaskScheduler taskScheduler, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getBrand(), MessageType.BRAND);
        this.message = fileResolver.getMessage().getBrand();
        this.permission = fileResolver.getPermission().getMessage().getBrand();
        this.fPlayerService = fPlayerService;
        this.taskScheduler = taskScheduler;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        Ticker ticker = this.message.getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::send), ticker.getPeriod());
        }
        this.listenerRegistry.register(BrandPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String format = this.getNextMessage(fPlayer, this.message.isRandom());
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(format)).destination(this.message.getDestination())).build());
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return ((Localization.Message.Brand)this.resolveLocalization(fPlayer)).getValues();
    }
}

