/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.bubble.service;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.bubble.BubbleModule;
import net.flectone.pulse.module.message.bubble.model.Bubble;
import net.flectone.pulse.module.message.bubble.model.ModernBubble;
import net.flectone.pulse.module.message.bubble.renderer.BubbleRenderer;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.converter.ColorConverter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.MessageFlag;
import org.jetbrains.annotations.NotNull;

@Singleton
public class BubbleService {
    private final Map<UUID, Queue<Bubble>> playerBubbleQueues = new ConcurrentHashMap<UUID, Queue<Bubble>>();
    private final FileResolver fileResolver;
    private final BubbleRenderer bubbleRenderer;
    private final ColorConverter colorConverter;
    private final TaskScheduler taskScheduler;
    private final PacketProvider packetProvider;
    private final RandomUtil randomUtil;
    private final MessagePipeline messagePipeline;

    @Inject
    public BubbleService(FileResolver fileResolver, BubbleRenderer bubbleRenderer, ColorConverter colorConverter, TaskScheduler taskScheduler, PacketProvider packetProvider, RandomUtil randomUtil, MessagePipeline messagePipeline) {
        this.fileResolver = fileResolver;
        this.bubbleRenderer = bubbleRenderer;
        this.colorConverter = colorConverter;
        this.taskScheduler = taskScheduler;
        this.packetProvider = packetProvider;
        this.randomUtil = randomUtil;
        this.messagePipeline = messagePipeline;
    }

    public void startTicker() {
        this.taskScheduler.runAsyncTimer(() -> this.playerBubbleQueues.forEach(this::processBubbleQueue), 5L, 5L);
    }

    public void addMessage(@NotNull FPlayer sender, @NotNull String message) {
        if (!this.bubbleRenderer.isCorrectPlayer(sender)) {
            return;
        }
        Queue bubbleQueue = this.playerBubbleQueues.computeIfAbsent(sender.getUuid(), uuid -> new ConcurrentLinkedQueue());
        message = this.messagePipeline.builder(sender, message).flag(MessageFlag.USER_MESSAGE, true).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).flag(MessageFlag.TRANSLATE_ITEM, false).plainSerializerBuild();
        List<Bubble> bubbles = this.splitMessageToBubbles(sender, message);
        bubbleQueue.addAll(bubbles);
    }

    private List<Bubble> splitMessageToBubbles(@NotNull FPlayer sender, @NotNull String message) {
        int id = this.randomUtil.nextInt(Integer.MAX_VALUE);
        Message.Bubble config = this.fileResolver.getMessage().getBubble();
        long duration = this.calculateDuration(message);
        int elevation = config.getElevation();
        float interactionHeight = config.getInteraction().getHeight();
        boolean useModernBubble = this.isModern();
        boolean useInteractionRiding = this.isInteractionRiding();
        String wordBreakHint = config.getWordBreakHint();
        Message.Bubble.Modern configModern = config.getModern();
        boolean hasShadow = configModern.isHasShadow();
        int background = this.colorConverter.parseHexToArgb(configModern.getBackground());
        int animationTime = configModern.getAnimationTime();
        float scale = configModern.getScale();
        BubbleModule.Billboard billboard = configModern.getBillboard();
        int maxLength = this.fileResolver.getMessage().getBubble().getMaxLength();
        ArrayList<Bubble> bubbles = new ArrayList<Bubble>();
        StringBuilder line = new StringBuilder();
        for (char symbol : message.toCharArray()) {
            boolean isLetter;
            line.append(symbol);
            if (line.length() < maxLength || !(isLetter = Character.isLetter(symbol)) && line.length() < maxLength + 5) continue;
            Object newMessage = isLetter ? String.valueOf(line) + wordBreakHint : line.toString().trim();
            bubbles.add(this.buildBubble(id, sender, (String)newMessage, duration, elevation, interactionHeight, useInteractionRiding, useModernBubble, hasShadow, background, animationTime, scale, billboard));
            line.setLength(0);
        }
        if (!line.isEmpty()) {
            bubbles.add(this.buildBubble(id, sender, line.toString(), duration, elevation, interactionHeight, useInteractionRiding, useModernBubble, hasShadow, background, animationTime, scale, billboard));
        }
        return bubbles;
    }

    private Bubble buildBubble(int id, FPlayer sender, String message, long duration, int elevation, float interactionHeight, boolean interactionRiding, boolean useModern, boolean hasShadow, int background, int animationTime, float scale, BubbleModule.Billboard billboard) {
        Bubble.Builder builder = useModern ? new ModernBubble.ModernBuilder().hasShadow(hasShadow).background(background).animationTime(animationTime).scale(scale).billboard(billboard) : new Bubble.Builder();
        return builder.id(id).sender(sender).message(message).duration(duration).elevation(elevation).interactionHeight(interactionHeight).interactionRiding(interactionRiding).build();
    }

    private void processBubbleQueue(UUID playerUuid, Queue<Bubble> bubbleQueue) {
        if (bubbleQueue == null || bubbleQueue.isEmpty()) {
            this.playerBubbleQueues.remove(playerUuid);
            return;
        }
        int maxCount = this.fileResolver.getMessage().getBubble().getMaxCount();
        bubbleQueue.removeIf(bubble -> {
            if (bubble.isExpired()) {
                this.bubbleRenderer.removeBubble((Bubble)bubble);
                return true;
            }
            return false;
        });
        bubbleQueue.stream().limit(maxCount).filter(bubble -> !bubble.isCreated()).forEach(this.bubbleRenderer::renderBubble);
    }

    public void clear(FPlayer fPlayer) {
        Queue<Bubble> bubbleQueue = this.playerBubbleQueues.get(fPlayer.getUuid());
        if (bubbleQueue == null) {
            return;
        }
        bubbleQueue.forEach(this.bubbleRenderer::removeBubble);
        this.playerBubbleQueues.remove(fPlayer.getUuid());
    }

    public void clear() {
        this.playerBubbleQueues.clear();
        this.bubbleRenderer.removeAllBubbles();
    }

    private long calculateDuration(String message) {
        Message.Bubble config = this.fileResolver.getMessage().getBubble();
        int countWords = message.split(" ").length;
        return (long)(((double)countWords + config.getHandicapChars()) / config.getReadSpeed() * 60.0) * 1000L;
    }

    private boolean isModern() {
        return this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_4) && this.fileResolver.getMessage().getBubble().getModern().isEnable();
    }

    private boolean isInteractionRiding() {
        return this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_3) && this.fileResolver.getMessage().getBubble().getInteraction().isEnable();
    }
}

