/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.chat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Cooldown;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.command.spy.SpyModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.bubble.BubbleModule;
import net.flectone.pulse.module.message.chat.listener.ChatPacketListener;
import net.flectone.pulse.module.message.chat.model.ChatMetadata;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.formatter.TimeFormatter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.PlatformType;
import org.incendo.cloud.type.tuple.Pair;

@Singleton
public class ChatModule
extends AbstractModuleLocalization<Localization.Message.Chat> {
    private final Map<String, Cooldown> cooldownMap = new HashMap<String, Cooldown>();
    private final Map<String, Sound> soundMap = new HashMap<String, Sound>();
    private final Message.Chat message;
    private final Permission.Message.Chat permission;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final PlatformServerAdapter platformServerAdapter;
    private final PermissionChecker permissionChecker;
    private final IntegrationModule integrationModule;
    private final TimeFormatter timeFormatter;
    private final Provider<BubbleModule> bubbleModuleProvider;
    private final Provider<SpyModule> spyModuleProvider;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public ChatModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, PlatformServerAdapter platformServerAdapter, PermissionChecker permissionChecker, IntegrationModule integrationModule, TimeFormatter timeFormatter, Provider<BubbleModule> bubbleModuleProvider, Provider<SpyModule> spyModuleProvider, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getChat(), MessageType.CHAT);
        this.message = fileResolver.getMessage().getChat();
        this.permission = fileResolver.getPermission().getMessage().getChat();
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.platformServerAdapter = platformServerAdapter;
        this.permissionChecker = permissionChecker;
        this.integrationModule = integrationModule;
        this.timeFormatter = timeFormatter;
        this.bubbleModuleProvider = bubbleModuleProvider;
        this.spyModuleProvider = spyModuleProvider;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.message.getTypes().forEach((key, value) -> {
            Permission.Message.Chat.Type permissions = this.permission.getTypes().get(key);
            if (permissions == null) {
                return;
            }
            this.registerPermission(permissions);
            this.cooldownMap.put((String)key, this.createCooldown(value.getCooldown(), permissions.getCooldownBypass()));
            this.soundMap.put((String)key, this.createSound(value.getSound(), permissions.getSound()));
        });
        if (this.message.getMode() == Message.Chat.Mode.PACKET || this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC) {
            this.listenerRegistry.register(ChatPacketListener.class);
        }
    }

    @Override
    public void onDisable() {
        this.cooldownMap.clear();
        this.soundMap.clear();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void send(FPlayer fPlayer, String eventMessage, Runnable cancelEvent, BiConsumer<String, Boolean> successEvent) {
        Cooldown cooldown;
        if (this.checkMute(fPlayer)) {
            cancelEvent.run();
            return;
        }
        Pair<String, Message.Chat.Type> playerChat = this.getPlayerChat(fPlayer, eventMessage);
        String chatName = (String)playerChat.first();
        Message.Chat.Type chatType = (Message.Chat.Type)playerChat.second();
        if (chatType == null || !chatType.isEnable()) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Message.Chat::getNullChat)).build());
            cancelEvent.run();
            return;
        }
        if (this.cooldownMap.containsKey(chatName) && (cooldown = this.cooldownMap.get(chatName)) != null && cooldown.isEnable() && !this.permissionChecker.check((FEntity)fPlayer, cooldown.getPermissionBypass()) && cooldown.isCooldown(fPlayer.getUuid())) {
            long timeLeft = this.cooldownMap.get(chatName).getTimeLeft(fPlayer);
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(this.timeFormatter.format(fPlayer, timeLeft, this.getCooldownMessage(fPlayer)))).build());
            cancelEvent.run();
            return;
        }
        String trigger = chatType.getTrigger();
        if (!StringUtils.isEmpty((CharSequence)trigger) && eventMessage.startsWith(trigger)) {
            eventMessage = eventMessage.substring(trigger.length()).trim();
        }
        Predicate<FPlayer> chatPermissionFilter = fReceiver -> this.permissionChecker.check((FEntity)fReceiver, this.permission.getTypes().get(chatName));
        Range chatRange = chatType.getRange();
        String finalMessage = chatRange.is(Range.Type.PROXY) || chatRange.is(Range.Type.SERVER) || chatRange.is(Range.Type.WORLD_NAME) || chatRange.is(Range.Type.WORLD_TYPE) ? this.integrationModule.checkMention(fPlayer, eventMessage) : eventMessage;
        EventMetadata chatMetadata = ((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)ChatMetadata.builder().sender(fPlayer)).format(localization -> localization.getTypes().get(chatName))).chatName(chatName)).chatType((Message.Chat.Type)playerChat.second())).destination(((Message.Chat.Type)playerChat.second()).getDestination())).range(chatRange)).message(finalMessage)).sound(this.soundMap.get(chatName))).filter(chatPermissionFilter)).proxy(dataOutputStream -> {
            dataOutputStream.writeString(chatName);
            dataOutputStream.writeString(finalMessage);
        })).integration()).build();
        List<FPlayer> receivers = this.createReceivers(chatMetadata);
        this.sendMessage(receivers, chatMetadata);
        int receiversCount = (int)receivers.stream().filter(fReceiver -> !fReceiver.isUnknown()).filter(fReceiver -> !fReceiver.equals(fPlayer)).filter(fReceiver -> this.integrationModule.canSeeVanished((FEntity)fReceiver, fPlayer)).count();
        ((SpyModule)this.spyModuleProvider.get()).checkChat(fPlayer, chatName, finalMessage);
        this.checkReceiversLater(fPlayer, chatRange, receiversCount, ((Message.Chat.Type)playerChat.second()).getNullReceiver());
        successEvent.accept(finalMessage, ((Message.Chat.Type)playerChat.second()).isCancel());
        ((BubbleModule)this.bubbleModuleProvider.get()).add(fPlayer, eventMessage);
    }

    @Async(delay=1L)
    public void checkReceiversLater(FPlayer fPlayer, Range chatRange, int receiversCount, Message.Chat.Type.NullReceiver nullReceiver) {
        if (!nullReceiver.isEnable() || receiversCount != 0) {
            return;
        }
        int onlinePlayersCount = (int)this.fPlayerService.findOnlineFPlayers().stream().filter(fReceiver -> !fReceiver.isUnknown()).filter(fReceiver -> !fReceiver.equals(fPlayer)).filter(fReceiver -> this.integrationModule.canSeeVanished((FEntity)fReceiver, fPlayer)).count();
        if (chatRange.is(Range.Type.BLOCKS) || onlinePlayersCount == 0) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Message.Chat::getNullReceiver)).destination(nullReceiver.getDestination())).build());
        }
    }

    public void send(FPlayer fPlayer, String proxyChatName, String string, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Optional<Map.Entry> optionalChat = this.message.getTypes().entrySet().stream().filter(chat -> ((String)chat.getKey()).equals(proxyChatName)).findAny();
        if (optionalChat.isEmpty()) {
            return;
        }
        String chatName = (String)optionalChat.get().getKey();
        Message.Chat.Type chatType = (Message.Chat.Type)optionalChat.get().getValue();
        Predicate<FPlayer> filter = this.rangeFilter(fPlayer, chatType.getRange()).and(fReceiver -> {
            if (!this.permissionChecker.check((FEntity)fReceiver, this.permission.getTypes().get(chatName))) {
                return false;
            }
            return this.platformPlayerAdapter.isOnline((FPlayer)fReceiver);
        });
        this.sendMessage(((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)ChatMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).format(s -> s.getTypes().get(chatName))).chatName(chatName)).chatType(chatType)).range(Range.get(Range.Type.SERVER))).destination(chatType.getDestination())).message(string)).sound(this.getModuleSound())).filter(filter)).build());
    }

    private Pair<String, Message.Chat.Type> getPlayerChat(FPlayer fPlayer, String eventMessage) {
        String returnedChatName = fPlayer.getSettingValue(FPlayer.Setting.CHAT);
        Message.Chat.Type playerChat = this.message.getTypes().get(returnedChatName);
        if (playerChat != null && !StringUtils.isEmpty((CharSequence)playerChat.getTrigger())) {
            return Pair.of((Object)returnedChatName, (Object)playerChat);
        }
        int priority = Integer.MIN_VALUE;
        for (Map.Entry<String, Message.Chat.Type> entry : this.message.getTypes().entrySet()) {
            Message.Chat.Type chat = entry.getValue();
            String chatName = entry.getKey();
            if (!chat.isEnable() || chat.getTrigger() != null && !chat.getTrigger().isEmpty() && !eventMessage.startsWith(chat.getTrigger()) || eventMessage.equals(chat.getTrigger()) || chat.getPriority() <= priority || !this.permissionChecker.check((FEntity)fPlayer, this.permission.getTypes().get(chatName))) continue;
            playerChat = chat;
            priority = chat.getPriority();
            returnedChatName = chatName;
        }
        return Pair.of((Object)returnedChatName, (Object)playerChat);
    }
}

