/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.clear;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.clear.listener.ClearPulseListener;
import net.flectone.pulse.module.message.clear.model.Clear;
import net.flectone.pulse.module.message.clear.model.ClearMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class ClearModule
extends AbstractModuleLocalization<Localization.Message.Clear> {
    private final Message.Clear message;
    private final Permission.Message.Clear permission;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public ClearModule(FileResolver fileResolver, FPlayerService fPlayerService, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getClear(), MessageType.CLEAR);
        this.message = fileResolver.getMessage().getClear();
        this.permission = fileResolver.getPermission().getMessage().getClear();
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(ClearPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, MinecraftTranslationKey key, Clear clear) {
        boolean isSingle;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = fPlayer;
        boolean bl = isSingle = key == MinecraftTranslationKey.COMMANDS_CLEAR_SUCCESS_SINGLE || key == MinecraftTranslationKey.COMMANDS_CLEAR_SUCCESS;
        if (isSingle && (fTarget = this.fPlayerService.getFPlayer(clear.value())).isUnknown()) {
            return;
        }
        this.sendMessage(((ClearMetadata.ClearMetadataBuilder)((ClearMetadata.ClearMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ClearMetadata.ClearMetadataBuilder)((ClearMetadata.ClearMetadataBuilder)((ClearMetadata.ClearMetadataBuilder)ClearMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(s -> StringUtils.replaceEach((String)(isSingle ? s.getSingle() : s.getMultiple()), (String[])new String[]{"<count>", "<number>"}, (String[])new String[]{clear.value(), clear.count()}))).clear(clear)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

