/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.clear.extractor;

import java.util.Optional;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.clear.model.Clear;
import net.flectone.pulse.processing.extractor.Extractor;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;

@Singleton
public class ClearExtractor
extends Extractor {
    @Inject
    public ClearExtractor() {
    }

    public Optional<Clear> extract(MessageReceiveEvent event) {
        String value;
        String count;
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (translatableComponent.args().size() < 2) {
            return Optional.empty();
        }
        Component component = translatableComponent.args().get(0);
        if (!(component instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent firstArg = (TextComponent)component;
        Component component2 = translatableComponent.args().get(1);
        if (!(component2 instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent secondArg = (TextComponent)component2;
        if (event.getTranslationKey() == MinecraftTranslationKey.COMMANDS_CLEAR_SUCCESS) {
            count = secondArg.content();
            value = this.extractTarget(firstArg);
        } else {
            count = firstArg.content();
            value = this.extractTarget(secondArg);
        }
        Clear clear = new Clear(count, value);
        return Optional.of(clear);
    }
}

