/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.clear.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.clear.ClearModule;
import net.flectone.pulse.module.message.clear.extractor.ClearExtractor;
import net.flectone.pulse.module.message.clear.model.Clear;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class ClearPulseListener
implements PulseListener {
    private final ClearModule clearModule;
    private final ClearExtractor clearExtractor;

    @Inject
    public ClearPulseListener(ClearModule clearModule, ClearExtractor clearExtractor) {
        this.clearModule = clearModule;
        this.clearExtractor = clearExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        MinecraftTranslationKey translationKey = event.getTranslationKey();
        if (!translationKey.startsWith("commands.clear.success")) {
            return;
        }
        Optional<Clear> clear = this.clearExtractor.extract(event);
        if (clear.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.clearModule.send(event.getFPlayer(), translationKey, clear.get());
    }
}

