/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.death;

import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDeathCombatEvent;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.death.listener.DeathPacketListener;
import net.flectone.pulse.module.message.death.listener.DeathPulseListener;
import net.flectone.pulse.module.message.death.model.Death;
import net.flectone.pulse.module.message.death.model.DeathMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@Singleton
public class DeathModule
extends AbstractModuleLocalization<Localization.Message.Death>
implements PulseListener {
    private final Message.Death message;
    private final Permission.Message.Death permission;
    private final MessagePipeline messagePipeline;
    private final PacketSender packetSender;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;
    private final IntegrationModule integrationModule;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    @Inject
    public DeathModule(FileResolver fileResolver, MessagePipeline messagePipeline, PacketSender packetSender, FPlayerService fPlayerService, ListenerRegistry listenerRegistry, IntegrationModule integrationModule) {
        super(localization -> localization.getMessage().getDeath(), MessageType.DEATH);
        this.message = fileResolver.getMessage().getDeath();
        this.permission = fileResolver.getPermission().getMessage().getDeath();
        this.messagePipeline = messagePipeline;
        this.packetSender = packetSender;
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
        this.integrationModule = integrationModule;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(DeathPacketListener.class);
        this.listenerRegistry.register(DeathPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fReceiver, Death death) {
        FPlayer player;
        FEntity fTarget = this.convertDeath(death);
        if (fTarget == null) {
            return;
        }
        if (!death.isPlayer()) {
            this.sendMessage(((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)DeathMetadata.builder().sender(fTarget)).filterPlayer(fReceiver)).format(s -> s.getTypes().get(death.getKey()))).death(death)).destination(this.message.getDestination())).sound(this.getModuleSound())).filter(fPlayer -> fPlayer.isSetting(FPlayer.Setting.DEATH) && this.integrationModule.canSeeVanished(fTarget, (FEntity)fPlayer))).tagResolvers(fResolver -> new TagResolver[]{this.killerTag((FPlayer)fResolver, death.getKiller()), this.byItemTag(death.getItem())})).build());
            return;
        }
        if (!fTarget.equals(fReceiver)) {
            return;
        }
        this.sendMessage(((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)((DeathMetadata.DeathMetadataBuilder)DeathMetadata.builder().sender(fTarget)).format(s -> s.getTypes().get(death.getKey()))).death(death)).range(this.message.getRange())).destination(this.message.getDestination())).sound(this.getModuleSound())).filter(fPlayer -> fPlayer.isSetting(FPlayer.Setting.DEATH) && this.integrationModule.canSeeVanished(fTarget, (FEntity)fPlayer))).tagResolvers(fResolver -> new TagResolver[]{this.killerTag((FPlayer)fResolver, death.getKiller()), this.byItemTag(death.getItem())})).proxy(dataOutputStream -> dataOutputStream.writeAsJson(death))).integration()).build());
        if (!death.isPlayer()) {
            return;
        }
        if (fTarget instanceof FPlayer && !(player = (FPlayer)fTarget).isSetting(FPlayer.Setting.DEATH)) {
            return;
        }
        Component component = this.messagePipeline.builder(fTarget, fReceiver, ((Localization.Message.Death)this.resolveLocalization(fReceiver)).getTypes().get(death.getKey())).tagResolvers(this.killerTag(fReceiver, death.getKiller()), this.byItemTag(death.getItem())).build();
        this.sendPersonalDeath(fReceiver, component);
    }

    @Sync
    public void sendPersonalDeath(FPlayer fPlayer, Component component) {
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerDeathCombatEvent(this.fPlayerService.getEntityId(fPlayer), null, component));
    }

    private FEntity convertDeath(Death death) {
        if (death == null) {
            return null;
        }
        if (!death.isPlayer()) {
            return new FEntity(death.getTargetName(), death.getTargetUUID(), death.getTargetType() == null ? death.getTargetName() : death.getTargetType());
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(death.getTargetName());
        if (fTarget.isUnknown()) {
            return null;
        }
        if (this.isModuleDisabledFor(fTarget)) {
            return null;
        }
        return fTarget;
    }

    public TagResolver byItemTag(String itemName) {
        Component itemComponent;
        String tag = "by_item";
        if (!this.isEnable()) {
            return MessagePipeline.ReplacementTag.empty(tag);
        }
        if (StringUtils.isEmpty((CharSequence)itemName)) {
            return MessagePipeline.ReplacementTag.empty(tag);
        }
        try {
            itemComponent = this.miniMessage.deserialize((Object)itemName);
        }
        catch (Exception ignored) {
            itemComponent = Component.text(itemName);
        }
        StyleSetter itemComponentWithHover = itemComponent.hoverEvent(HoverEvent.showText(itemComponent.decorate(TextDecoration.ITALIC)));
        return TagResolver.resolver((String)tag, (arg_0, arg_1) -> DeathModule.lambda$byItemTag$8((Component)itemComponentWithHover, arg_0, arg_1));
    }

    public TagResolver killerTag(FPlayer receiver, Death killer) {
        String tag = "killer";
        if (!this.isEnable()) {
            return MessagePipeline.ReplacementTag.empty(tag);
        }
        FEntity entity = this.convertDeath(killer);
        if (entity == null) {
            return MessagePipeline.ReplacementTag.empty(tag);
        }
        return TagResolver.resolver((String)tag, (argumentQueue, context) -> {
            Localization.Message.Death message = (Localization.Message.Death)this.resolveLocalization(receiver);
            Component component = this.messagePipeline.builder(entity, receiver, killer.isPlayer() ? message.getKillerPlayer() : message.getKillerEntity()).build();
            return Tag.selfClosingInserting((Component)component);
        });
    }

    private static /* synthetic */ Tag lambda$byItemTag$8(Component itemComponentWithHover, ArgumentQueue argumentQueue, Context context) {
        return Tag.selfClosingInserting((Component)itemComponentWithHover);
    }
}

