/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.death.extractor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.UUID;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.message.death.model.Death;
import net.flectone.pulse.processing.extractor.Extractor;
import net.flectone.pulse.util.EntityUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;

@Singleton
public class DeathExtractor
extends Extractor {
    private final EntityUtil entityUtil;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    @Inject
    public DeathExtractor(EntityUtil entityUtil) {
        this.entityUtil = entityUtil;
    }

    public String extractItemName(TranslatableComponent translatableComponent) {
        String string;
        Component itemComp;
        if (translatableComponent.args().size() < 3) {
            return null;
        }
        Component component = itemComp = translatableComponent.args().get(2);
        Objects.requireNonNull(component);
        Component component2 = component;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslatableComponent.class, TextComponent.class}, (Object)component2, n)) {
                case 0: {
                    TranslatableComponent transComp = (TranslatableComponent)component2;
                    if (!transComp.key().equals("chat.square_brackets") || transComp.args().isEmpty()) {
                        n = 1;
                        continue block4;
                    }
                    string = this.extractItemComponent(transComp.args().get(0));
                    break block4;
                }
                case 1: {
                    TextComponent textComp = (TextComponent)component2;
                    if (!textComp.content().equals("[") || textComp.children().isEmpty()) {
                        n = 2;
                        continue block4;
                    }
                    string = this.extractItemComponent(textComp.children().get(0));
                    break block4;
                }
                default: {
                    string = null;
                    break block4;
                }
            }
            break;
        }
        String itemName = string;
        if (StringUtils.isEmpty(itemName)) {
            return null;
        }
        return itemName;
    }

    public Death extractDeath(TranslatableComponent translatableComponent, int index) {
        if (translatableComponent.args().size() < index + 1) {
            return null;
        }
        Component component = translatableComponent.args().get(index);
        Objects.requireNonNull(component);
        Component component2 = component;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslatableComponent.class, TextComponent.class}, (Object)component2, n)) {
            case 0 -> {
                Death var5_17;
                Object var11_13;
                HoverEvent<?> hoverEvent;
                TranslatableComponent targetComponent = (TranslatableComponent)component2;
                Death death = new Death(translatableComponent.key());
                death.setTargetName(targetComponent.key());
                death.setPlayer(false);
                String insertion = targetComponent.insertion();
                if (StringUtils.isNotEmpty((CharSequence)insertion)) {
                    try {
                        death.setTargetUUID(UUID.fromString(insertion));
                    }
                    catch (IllegalArgumentException var9_10) {
                        // empty catch block
                    }
                }
                if ((hoverEvent = targetComponent.hoverEvent()) != null && (var11_13 = hoverEvent.value()) instanceof HoverEvent.ShowEntity) {
                    HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)var11_13;
                    death.setTargetUUID(showEntity.id());
                    death.setTargetType(this.entityUtil.resolveEntityTranslationKey(showEntity.type().key().value()));
                    if (showEntity.type().value().equalsIgnoreCase("player")) {
                        death.setPlayer(true);
                    }
                } else {
                    death.setTargetType(targetComponent.key());
                }
                yield var5_17 = death;
            }
            case 1 -> {
                Death var5_21;
                HoverEvent<?> hoverEvent;
                TextComponent extraText;
                Component uuid;
                TextComponent targetComponent = (TextComponent)component2;
                String target = targetComponent.content();
                String insertion = targetComponent.insertion();
                Death death = null;
                if (!target.isEmpty()) {
                    death = new Death(translatableComponent.key());
                    death.setTargetName(target);
                    death.setPlayer(true);
                    if (StringUtils.isNotEmpty((CharSequence)insertion)) {
                        try {
                            Death var5_18;
                            UUID uuid = UUID.fromString(insertion);
                            death.setTargetUUID(uuid);
                            death.setPlayer(false);
                            death.setTargetType(target);
                            yield var5_18 = death;
                        }
                        catch (IllegalArgumentException uuid) {}
                    }
                } else if (!targetComponent.children().isEmpty() && (uuid = targetComponent.children().getFirst()) instanceof TextComponent && !(extraText = (TextComponent)uuid).content().isEmpty()) {
                    death = new Death(translatableComponent.key());
                    death.setTargetName(extraText.content());
                    death.setPlayer(true);
                }
                if ((hoverEvent = targetComponent.hoverEvent()) == null) {
                    Death var5_19;
                    yield var5_19 = death;
                }
                Object var13_26 = hoverEvent.value();
                if (var13_26 instanceof HoverEvent.ShowEntity) {
                    HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)var13_26;
                    Component var14_27 = showEntity.name();
                    if (!(var14_27 instanceof TextComponent)) {
                        Death var5_20;
                        yield var5_20 = death;
                    }
                    TextComponent hoverComponent = (TextComponent)var14_27;
                    if (death != null && !showEntity.type().value().equalsIgnoreCase("player")) {
                        death.setPlayer(false);
                        death.setTargetUUID(showEntity.id());
                        death.setTargetType(this.entityUtil.resolveEntityTranslationKey(showEntity.type().key().value()));
                    }
                    if (!hoverComponent.children().isEmpty() && hoverComponent.children().get(0) instanceof TextComponent) {
                        death = new Death(translatableComponent.key());
                        StringBuilder targetNameBuilder = new StringBuilder();
                        for (int i = 0; i < hoverComponent.children().size(); ++i) {
                            Component var17_30 = hoverComponent.children().get(i);
                            if (!(var17_30 instanceof TextComponent)) continue;
                            TextComponent textComponent = (TextComponent)var17_30;
                            targetNameBuilder.append(textComponent.content());
                        }
                        death.setTargetName(targetNameBuilder.toString());
                        death.setTargetUUID(showEntity.id());
                        death.setTargetType(this.entityUtil.resolveEntityTranslationKey(showEntity.type().key().value()));
                        death.setPlayer(showEntity.type().value().equalsIgnoreCase("player"));
                    }
                }
                yield var5_21 = death;
            }
            default -> {
                Death var5_22;
                yield var5_22 = null;
            }
        };
    }

    private String extractItemComponent(Component component) {
        try {
            return (String)this.miniMessage.serialize(component);
        }
        catch (Exception ignored) {
            Component itemText;
            TextComponent extraText;
            if (component instanceof TextComponent && !(extraText = (TextComponent)component).children().isEmpty() && (itemText = extraText.children().getFirst()) instanceof TextComponent) {
                TextComponent itemTextComp = (TextComponent)itemText;
                return itemTextComp.content();
            }
            return null;
        }
    }
}

