/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.deop;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.deop.listener.DeopPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class DeopModule
extends AbstractModuleLocalization<Localization.Message.Deop> {
    private final Message.Deop message;
    private final Permission.Message.Deop permission;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public DeopModule(FileResolver fileResolver, FPlayerService fPlayerService, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getDeop(), MessageType.DEOP);
        this.message = fileResolver.getMessage().getDeop();
        this.permission = fileResolver.getPermission().getMessage().getDeop();
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(DeopPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, String target) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(target);
        if (fTarget.isUnknown()) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fTarget)).filterPlayer(fPlayer)).format(Localization.Message.Deop::getFormat)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

